package com.bitctrl.lib.eclipse.databinding.validator;

import java.util.Map;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * Validiert einen Wert anhand des zu ihm gemappten Wertes und einer Liste von
 * {@link IValidator Validatoren}. Enthlt die Map keinen entsprechenden
 * Schlssel, wird {@link Status#OK_STATUS} zurckgeliefert.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id$
 */
public class MapValidator implements IValidator {

	private final Map<?, ?> map;
	private final IValidator[] validators;

	public MapValidator(final Map<?, ?> map, final IValidator... validators) {
		this.map = map;
		this.validators = validators;
	}

	@Override
	public IStatus validate(final Object value) {
		if (map.containsKey(value)) {
			return StatusUtils.mergeStatus(map.get(value), validators);
		} else {
			return Status.OK_STATUS;
		}
	}
}
