package com.bitctrl.lib.eclipse.databinding.validator;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;

/**
 * <p>
 * IObservableValue for an IMessage. Handles values of type IStatus.
 * </p>
 * <p>
 * Copied from
 * <a href="https://bugs.eclipse.org/bugs/attachment.cgi?id=104283">Eclipse
 * Bugzilla</a>
 * </p>
 *
 * @author Sebastian Fuchs
 * @since 03.04.2007
 */
public class MessageObservableValue extends AbstractObservableValue {

	private IStatus status;
	private Status2MessageManagerConnector connector;
	private Control control;

	/**
	 * @param msgManager the IMessageManager, never <code>null</code>
	 * @param control    the control which the status belongs to or
	 *                   <code>null</code> when the status is a form wide status
	 */
	public MessageObservableValue(final IMessageManager msgManager, final Control control) {
		super();
		init(msgManager, control);
	}

	/**
	 * @param realm
	 * @param msgManager the IMessageManager, never <code>null</code>
	 * @param control    the control which the status belongs to or
	 *                   <code>null</code> when the status is a form wide status
	 * @see AbstractObservableValue#AbstractObservableValue(Realm)
	 */
	public MessageObservableValue(final Realm realm, final IMessageManager msgManager, final Control control) {
		super(realm);
		init(msgManager, control);
	}

	private void init(final IMessageManager msgManager, final Control control) {
		connector = new Status2MessageManagerConnector(msgManager);
		this.control = control;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * org.eclipse.core.databinding.observable.value.IObservableValue#getValueType
	 * ()
	 */
	@Override
	public Object getValueType() {
		return IStatus.class;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.core.databinding.observable.value.AbstractObservableValue
	 * #doGetValue()
	 */
	@Override
	protected Object doGetValue() {
		return status;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.core.databinding.observable.value.AbstractObservableValue
	 * #doSetValue(java.lang.Object)
	 */
	@Override
	protected void doSetValue(final Object value) {
		Assert.isLegal(value instanceof IStatus);
		connector.setMessage((IStatus) value, control);
	}
}
