package com.bitctrl.lib.eclipse.databinding.validator;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IMessagePrefixProvider;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.forms.MessageManager;

/**
 * Im Unterschied zum {@link MessageManager#DefaultPrefixProvider} wird nicht
 * das nchst-beste Label fr den Text herran gezogen.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id: MessagePrefixProvider.java 21700 2010-02-23 12:24:32Z schnepel
 *          $
 */
@SuppressWarnings("restriction")
public class MessagePrefixProvider implements IMessagePrefixProvider {

	@Override
	public String getPrefix(final Control c) {
		final Composite parent = c.getParent();
		final Control[] siblings = parent.getChildren();
		for (int i = 0; i < siblings.length; i++) {
			if (siblings[i] == c) {
				// this is us - go backward until you hit
				// a label-like widget
				for (int j = i - 1; j >= 0; j--) {
					final Control label = siblings[j];
					String ltext = null;
					if (label instanceof Label) {
						ltext = ((Label) label).getText();
					} else if (label instanceof Hyperlink) {
						ltext = ((Hyperlink) label).getText();
					} else if (label instanceof CLabel) {
						ltext = ((CLabel) label).getText();
					}
					if (ltext != null && 0 != ltext.trim().length()) {
						if (!ltext.endsWith(":")) {
							return ltext + ": "; //$NON-NLS-1$
						}
						return ltext + " "; //$NON-NLS-1$
					}
				}
				break;
			}
		}
		return null;
	}
}