package com.bitctrl.lib.eclipse.databinding.validator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;

/**
 * <p>
 * Sets a message in an IMessageManager by an IStatus.
 * </p>
 * <p>
 * Copied from
 * <a href="https://bugs.eclipse.org/bugs/attachment.cgi?id=104282">Eclipse
 * Bugzilla</a>
 * </p>
 *
 * @author Sebastian Fuchs
 * @since 03.04.2007
 */
public class Status2MessageManagerConnector {

	private final IMessageManager manager;

	/**
	 * @param manager
	 */
	public Status2MessageManagerConnector(final IMessageManager manager) {
		this.manager = manager;
	}

	/**
	 * Sets the message for the given control and status
	 *
	 * @param status
	 * @param control the control in the form or <code>null</code> for a form wide
	 *                message
	 */
	public void setMessage(final IStatus status, final Control control) {
		if (status.isOK()) {
			removeMsg(control);
		} else {
			addMsg(status, control);
		}
	}

	private void addMsg(final IStatus status, final Control control) {
		final String messageText = status.getMessage();
		int type;
		switch (status.getSeverity()) {
		case IStatus.CANCEL:
			type = IMessageProvider.ERROR;
			break;
		case IStatus.ERROR:
			type = IMessageProvider.ERROR;
			break;
		case IStatus.WARNING:
			type = IMessageProvider.WARNING;
			break;
		case IStatus.INFO:
			type = IMessageProvider.WARNING; // TODO
			// IMessageProvider.INFORMATION;
			// see
			// http://192.168.99.50/bugzilla/show_bug.cgi?id=35
			break;
		case IStatus.OK:
			type = IMessageProvider.NONE;
			break;
		default:
			type = IMessageProvider.NONE;
			break;
		}

		if (control == null) {
			manager.addMessage(this, messageText, status, type);
		} else {
			manager.addMessage(this, messageText, status, type, control);
		}
	}

	private void removeMsg(final Control control) {
		if (control == null) {
			manager.removeMessage(this);
		} else {
			manager.removeMessage(this, control);
		}
	}
}
