package com.bitctrl.lib.eclipse.databinding.validator;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public final class StatusUtils {

	private static String PLUGIN_ID = "com.bitctrl.lib.eclipse.databinding";

	public static IStatus failureMessage(final int severity, final String errorText) {
		switch (severity) {
		case IStatus.INFO:
			return ValidationStatus.info(errorText);
		case IStatus.WARNING:
			return ValidationStatus.warning(errorText);
		case IStatus.ERROR:
			return ValidationStatus.error(errorText);
		default:
			final IStatus childError = ValidationStatus.error(errorText);
			return new MultiStatus("", -1, new IStatus[] { childError }, "Invalid severity code " + severity + "!",
					null);
		}
	}

	public static IStatus mergeStatus(IStatus merged, final IStatus newStatus) {
		if (null == merged || merged.isOK()) {
			return null == newStatus ? Status.OK_STATUS : newStatus;
		}
		if (null == newStatus || newStatus.isOK()) {
			return merged;
		}
		if (!(merged instanceof MultiStatus)) {
			merged = new MultiStatus(PLUGIN_ID, -1, new IStatus[] { merged, newStatus },
					"Es sind mehrere Fehler bei der Validierung aufgetreten!" + "\n  " + merged.getMessage() + "\n  "
							+ newStatus.getMessage(),
					null);
		} else {
			// there isn't a setMessage() ...
			MultiStatus mm = (MultiStatus) merged;
			mm = new MultiStatus(PLUGIN_ID, -1, mm.getChildren(), mm.getMessage() + "\n  " + newStatus.getMessage(),
					null);
			mm.add(newStatus);
			merged = mm;
		}
		return merged;
	}

	public static IStatus mergeStatus(final Object element, final IValidator... validators) {
		return mergeStatus(Status.OK_STATUS, element, validators);
	}

	public static IStatus mergeStatus(IStatus merged, final Object element, final IValidator... validators) {
		for (final IValidator validator : validators) {
			merged = StatusUtils.mergeStatus(merged, validator.validate(element));
		}
		return merged;
	}

	public static IStatus mergeStatus(final IStatus... stati) {
		final IStatus merged = Status.OK_STATUS;
		for (final IStatus status : stati) {
			mergeStatus(merged, status);
		}
		return merged;
	}
}
