/*
 * Rahmenwerk-Plug-in "Baustellen- und Unfalleingabe"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package com.bitctrl.lib.eclipse.databinding.validator;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

/**
 * Validator, der einen String auf verschiedene Bedingungen (nicht-null,
 * minimale Lnge, maximale Lnge) berprft.
 *
 * @author BitCtrl Systems GmbH, Andreas Meissner
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id$
 */
public class StringValidator implements IValidator {

	private final Integer minLength;
	private final Integer maxLength;
	private final boolean nullAllowed;
	private final String minErrorText;
	private final String maxErrorText;
	private final String nullErrorText;
	private final boolean trim;
	private int severity = IStatus.ERROR;

	/**
	 * Der Konstruktor.
	 */
	public StringValidator(final String errorText) {
		this(true, 1, errorText, null, null, false, errorText);
	}

	/**
	 * Der Konstruktor.
	 */
	public StringValidator(final Integer minLength, final String minAndNullErrorText) {
		this(true, minLength, minAndNullErrorText, null, null, 0 == minLength, minAndNullErrorText);
	}

	/**
	 * Der Konstruktor.
	 */
	public StringValidator(final Integer minLength, final String minErrorText, final Integer maxLength,
			final String maxErrorText) {
		this(true, minLength, minErrorText, maxLength, maxErrorText, 0 == minLength, null);
	}

	/**
	 * Der Konstruktor.
	 */
	public StringValidator(final boolean trim, final Integer minLength, final String minErrorText,
			final Integer maxLength, final String maxErrorText, final boolean nullAllowed, final String nullErrorText) {
		this.trim = trim;
		this.minLength = minLength;
		this.minErrorText = minErrorText;
		this.maxLength = maxLength;
		this.maxErrorText = maxErrorText;
		this.nullAllowed = nullAllowed;
		this.nullErrorText = nullErrorText;
	}

	/** {@inheritDoc} */
	@Override
	public IStatus validate(final Object value) {
		if (null == value && !nullAllowed) {
			return StatusUtils.failureMessage(severity, nullErrorText);
		}
		if (value instanceof String) {
			String text = (String) value;
			if (trim) {
				text = text.trim();
			}
			if (minLength != null && text.length() < minLength) {
				return StatusUtils.failureMessage(severity, minErrorText);
			}
			if (maxLength != null && text.length() > maxLength) {
				return StatusUtils.failureMessage(severity, maxErrorText);
			}
			return ValidationStatus.ok();
		}
		if (value != null) {
			return ValidationStatus.error("Wert ist keine Zeichenkette!");
		} else {
			return ValidationStatus.ok();
		}
	}

	public IValidator setSeverity(final int severity) {
		this.severity = severity;
		return this;
	}
}
