package com.bitctrl.lib.eclipse.databinding.validator;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

/**
 * Prft, wie oft ein Objekt in einer {@link Collection} enthalten ist.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 * @version $Id$
 */
public class UniquenessValidator implements IValidator {

	private final Collection<?> values;
	private final boolean selfIncluding;
	private final String errorText;

	public UniquenessValidator(final Collection<?> values, final boolean selfIncluding, final String errorText) {
		this.values = values;
		this.selfIncluding = selfIncluding;
		this.errorText = errorText;
	}

	@Override
	public IStatus validate(final Object value) {
		final int count = Collections.frequency(values, value);
		if (selfIncluding ? count > 1 : count > 0) {
			return ValidationStatus.error(errorText);
		} else {
			return ValidationStatus.ok();
		}
	}
}
