package com.bitctrl.lib.eclipse.databinding.widgets;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;

public class DecorationHelper {

	/**
	 * Erzeugt fr ein gegebenes Widget eine Dekoration zur Anzeige von Fehlern oder
	 * Warnung.
	 *
	 * @param control        das zu dekorierende Widget
	 * @param text           der Fehlertext
	 * @param decorationType die Art der Dekoration,
	 *                       {@link FieldDecorationRegistry}.DEC_*
	 *
	 * @return eine Dekoration zur Anzeige von Fehlern oder Warnung
	 *
	 * @see FieldDecorationRegistry
	 */
	public static ControlDecoration erzeugeErrorControlDecoration(final Control control, final String text,
			final String decorationType) {
		final ControlDecoration controlDecoration = new ControlDecoration(control, SWT.LEFT | SWT.TOP);
		controlDecoration.setDescriptionText(text);
		final FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration(decorationType);
		controlDecoration.setImage(fieldDecoration.getImage());
		return controlDecoration;
	}

}
