package com.bitctrl.lib.eclipse.databinding.wizards;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * @author BitCtrl Systems GmbH, schnepel
 * @version $Id: EnterOrSelectStringWizardPage.java 21686 2010-02-22 09:48:59Z
 *          schnepel $
 */
public class EnterOrSelectStringWizardPage extends WizardPage {
	private final String title;
	private final String description;
	private final String prompt1;
	private final String prompt2;
	private final String prompt3;
	private final IObservableSet names;
	private Text nameField;
	private ListViewer nameList;

	final private IObservableValue data;

	public EnterOrSelectStringWizardPage(final String title, final String description, final String prompt1,
			final String prompt2, final String prompt3, final IObservableValue value, final IObservableSet values) {
		super(EnterOrSelectStringWizardPage.class.getName());
		this.title = title;
		this.description = description;
		this.prompt1 = prompt1;
		this.prompt2 = prompt2;
		this.prompt3 = prompt3;
		names = values;
		data = value;
	}

	// @Override // geht nicht mit Java 1.5
	@Override
	public void createControl(final Composite parent) {
		setTitle(title);
		if (null != description) {
			setDescription(description);
		}
		final Composite comp = new Composite(parent, SWT.NONE);

		final GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		comp.setLayout(layout);

		final DataBindingContext dbc = new DataBindingContext();
		if (prompt1 != null) {
			new Label(comp, SWT.NONE).setText(prompt1);
			nameField = new Text(comp, SWT.BORDER);
			nameField.setLayoutData(new GridData(SWT.FILL, SWT.NONE, true, false));
			dbc.bindValue(SWTObservables.observeText(nameField, SWT.Modify), data, null, null);
		}
		new Label(comp, SWT.NONE).setText("");
		if (prompt2 != null) {
			new Label(comp, SWT.NONE).setText(prompt2);
			new Label(comp, SWT.NONE).setText("");
		}
		new Label(comp, SWT.NONE).setText(prompt3);
		if (prompt3 != null) {
			nameList = new ListViewer(comp, SWT.SINGLE | SWT.BORDER);
			nameList.getControl().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
			nameList.setContentProvider(new ObservableSetContentProvider());
			nameList.setInput(names);
			dbc.bindValue(SWTObservables.observeSelection(nameList.getControl()), data, null, null);
		}
		setControl(comp);
		data.addValueChangeListener(new IValueChangeListener() {
			@Override
			public void handleValueChange(final ValueChangeEvent event) {
				validatePage();
			}
		});
		validatePage();
	}

	public void validatePage() {
		setPageComplete(null != data.getValue() && data.getValue().toString().trim().length() > 0);
	}
}
