/**
 * BitCtrl Rahmenwerk Plug-in
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * WeiÃenfelser StraÃe 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package com.bitctrl.lib.eclipse.emf.davbitctrl.model;

import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.DavbitctrlFactory
 * @model kind="package"
 * @generated
 */
public interface DavbitctrlPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "davbitctrl";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://com.bitctrl.lib.eclipse.davbitctrl/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "davbitctrl";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	DavbitctrlPackage eINSTANCE = com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl
			.init();

	/**
	 * The meta object id for the '<em>Bild</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getBild()
	 * @generated
	 */
	int BILD = 0;

	/**
	 * The meta object id for the '<em>Netz</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getNetz()
	 * @generated
	 */
	int NETZ = 1;

	/**
	 * The meta object id for the '<em>System Objekt</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getSystemObjekt()
	 * @generated
	 */
	int SYSTEM_OBJEKT = 2;

	/**
	 * The meta object id for the '<em>Mess Querschnitt Allgemein</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getMessQuerschnittAllgemein()
	 * @generated
	 */
	int MESS_QUERSCHNITT_ALLGEMEIN = 3;

	/**
	 * The meta object id for the '<em>Fahr Streifen</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getFahrStreifen()
	 * @generated
	 */
	int FAHR_STREIFEN = 4;

	/**
	 * The meta object id for the '<em>Portable Bitmap</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getPortableBitmap()
	 * @generated
	 */
	int PORTABLE_BITMAP = 5;

	/**
	 * The meta object id for the '<em>Strassen Segment</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getStrassenSegment()
	 * @generated
	 */
	int STRASSEN_SEGMENT = 6;

	/**
	 * The meta object id for the '<em>Kreis</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Kreis
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getKreis()
	 * @generated
	 */
	int KREIS = 7;

	/**
	 * The meta object id for the '<em>Ortslage</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortslage
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getOrtslage()
	 * @generated
	 */
	int ORTSLAGE = 8;

	/**
	 * The meta object id for the '<em>Ortsname</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortsname
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getOrtsname()
	 * @generated
	 */
	int ORTSNAME = 9;

	/**
	 * The meta object id for the '<em>Strassen Knoten</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getStrassenKnoten()
	 * @generated
	 */
	int STRASSEN_KNOTEN = 10;

	/**
	 * The meta object id for the '<em>Stoerfall Indikator</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getStoerfallIndikator()
	 * @generated
	 */
	int STOERFALL_INDIKATOR = 11;

	/**
	 * The meta object id for the '<em>Umfeld Daten Mess Stelle</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getUmfeldDatenMessStelle()
	 * @generated
	 */
	int UMFELD_DATEN_MESS_STELLE = 12;

	/**
	 * The meta object id for the '<em>Anzeige Querschnitt</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getAnzeigeQuerschnitt()
	 * @generated
	 */
	int ANZEIGE_QUERSCHNITT = 13;

	/**
	 * The meta object id for the '<em>Gewaesser</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Gewaesser
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getGewaesser()
	 * @generated
	 */
	int GEWAESSER = 14;

	/**
	 * The meta object id for the '<em>Situation</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getSituation()
	 * @generated
	 */
	int SITUATION = 15;

	/**
	 * The meta object id for the '<em>Baustelle</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getBaustelle()
	 * @generated
	 */
	int BAUSTELLE = 16;

	/**
	 * The meta object id for the '<em>Stau</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getStau()
	 * @generated
	 */
	int STAU = 17;

	/**
	 * The meta object id for the '<em>Unfall</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Unfall
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getUnfall()
	 * @generated
	 */
	int UNFALL = 18;

	/**
	 * The meta object id for the '<em>Rds Meldung</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getRdsMeldung()
	 * @generated
	 */
	int RDS_MELDUNG = 19;

	/**
	 * The meta object id for the '<em>Ufds Wind Geschwindigkeit Mittel Wert</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitMittelWert
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getUfdsWindGeschwindigkeitMittelWert()
	 * @generated
	 */
	int UFDS_WIND_GESCHWINDIGKEIT_MITTEL_WERT = 20;

	/**
	 * The meta object id for the '<em>Ufds Wind Geschwindigkeit Spitzen Wert</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitSpitzenWert
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getUfdsWindGeschwindigkeitSpitzenWert()
	 * @generated
	 */
	int UFDS_WIND_GESCHWINDIGKEIT_SPITZEN_WERT = 21;

	/**
	 * The meta object id for the '<em>Ufds Wind Richtung</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindRichtung
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getUfdsWindRichtung()
	 * @generated
	 */
	int UFDS_WIND_RICHTUNG = 22;

	/**
	 * The meta object id for the '<em>Vba Event</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getVbaEvent()
	 * @generated
	 */
	int VBA_EVENT = 23;

	/**
	 * The meta object id for the '<em>Gma</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.Gma
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getGma()
	 * @generated
	 */
	int GMA = 24;

	/**
	 * The meta object id for the '<em>Geo Referenz Objekt</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.GeoReferenzObjekt
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getGeoReferenzObjekt()
	 * @generated
	 */
	int GEO_REFERENZ_OBJEKT = 25;

	/**
	 * The meta object id for the '<em>Punkt</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getPunkt()
	 * @generated
	 */
	int PUNKT = 26;

	/**
	 * The meta object id for the '<em>Punkt XY</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getPunktXY()
	 * @generated
	 */
	int PUNKT_XY = 27;

	/**
	 * The meta object id for the '<em>Punkt Liegt Auf Linien Objekt</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getPunktLiegtAufLinienObjekt()
	 * @generated
	 */
	int PUNKT_LIEGT_AUF_LINIEN_OBJEKT = 28;

	/**
	 * The meta object id for the '<em>Linie</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getLinie()
	 * @generated
	 */
	int LINIE = 29;

	/**
	 * The meta object id for the '<em>Linie XY</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.LinieXY
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getLinieXY()
	 * @generated
	 */
	int LINIE_XY = 30;

	/**
	 * The meta object id for the '<em>Besteht Aus Linien Objekten</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.BestehtAusLinienObjekten
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getBestehtAusLinienObjekten()
	 * @generated
	 */
	int BESTEHT_AUS_LINIEN_OBJEKTEN = 31;

	/**
	 * The meta object id for the '<em>Flaeche</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getFlaeche()
	 * @generated
	 */
	int FLAECHE = 32;

	/**
	 * The meta object id for the '<em>Flaeche XY</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.FlaecheXY
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getFlaecheXY()
	 * @generated
	 */
	int FLAECHE_XY = 33;

	/**
	 * The meta object id for the '<em>Komplex</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getKomplex()
	 * @generated
	 */
	int KOMPLEX = 34;

	/**
	 * The meta object id for the '<em>Komplex XY</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.KomplexXY
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getKomplexXY()
	 * @generated
	 */
	int KOMPLEX_XY = 35;

	/**
	 * The meta object id for the '<em>Tmc Verkehrs Meldung</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getTmcVerkehrsMeldung()
	 * @generated
	 */
	int TMC_VERKEHRS_MELDUNG = 36;

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild <em>Bild</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Bild</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild"
	 * @generated
	 */
	EDataType getBild();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz <em>Netz</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Netz</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz"
	 * @generated
	 */
	EDataType getNetz();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt <em>System Objekt</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>System Objekt</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt"
	 * @generated
	 */
	EDataType getSystemObjekt();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein <em>Mess Querschnitt Allgemein</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Mess Querschnitt Allgemein</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein"
	 * @generated
	 */
	EDataType getMessQuerschnittAllgemein();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen <em>Fahr Streifen</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Fahr Streifen</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen"
	 * @generated
	 */
	EDataType getFahrStreifen();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap <em>Portable Bitmap</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Portable Bitmap</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap"
	 * @generated
	 */
	EDataType getPortableBitmap();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment <em>Strassen Segment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Strassen Segment</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment"
	 * @generated
	 */
	EDataType getStrassenSegment();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Kreis <em>Kreis</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Kreis</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Kreis
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Kreis"
	 * @generated
	 */
	EDataType getKreis();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortslage <em>Ortslage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Ortslage</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortslage
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortslage"
	 * @generated
	 */
	EDataType getOrtslage();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortsname <em>Ortsname</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Ortsname</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortsname
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortsname"
	 * @generated
	 */
	EDataType getOrtsname();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten <em>Strassen Knoten</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Strassen Knoten</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten"
	 * @generated
	 */
	EDataType getStrassenKnoten();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator <em>Stoerfall Indikator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Stoerfall Indikator</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator"
	 * @generated
	 */
	EDataType getStoerfallIndikator();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle <em>Umfeld Daten Mess Stelle</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Umfeld Daten Mess Stelle</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle"
	 * @generated
	 */
	EDataType getUmfeldDatenMessStelle();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt <em>Anzeige Querschnitt</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Anzeige Querschnitt</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt"
	 * @generated
	 */
	EDataType getAnzeigeQuerschnitt();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Gewaesser <em>Gewaesser</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Gewaesser</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Gewaesser
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Gewaesser"
	 * @generated
	 */
	EDataType getGewaesser();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation <em>Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Situation</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation"
	 * @generated
	 */
	EDataType getSituation();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle <em>Baustelle</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Baustelle</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle"
	 * @generated
	 */
	EDataType getBaustelle();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau <em>Stau</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Stau</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau"
	 * @generated
	 */
	EDataType getStau();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Unfall <em>Unfall</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Unfall</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Unfall
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Unfall"
	 * @generated
	 */
	EDataType getUnfall();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung <em>Rds Meldung</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Rds Meldung</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung"
	 * @generated
	 */
	EDataType getRdsMeldung();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitMittelWert <em>Ufds Wind Geschwindigkeit Mittel Wert</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Ufds Wind Geschwindigkeit Mittel Wert</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitMittelWert
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitMittelWert"
	 * @generated
	 */
	EDataType getUfdsWindGeschwindigkeitMittelWert();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitSpitzenWert <em>Ufds Wind Geschwindigkeit Spitzen Wert</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Ufds Wind Geschwindigkeit Spitzen Wert</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitSpitzenWert
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitSpitzenWert"
	 * @generated
	 */
	EDataType getUfdsWindGeschwindigkeitSpitzenWert();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindRichtung <em>Ufds Wind Richtung</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Ufds Wind Richtung</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindRichtung
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindRichtung"
	 * @generated
	 */
	EDataType getUfdsWindRichtung();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent <em>Vba Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Vba Event</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent"
	 * @generated
	 */
	EDataType getVbaEvent();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.Gma <em>Gma</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Gma</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.Gma
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.Gma"
	 * @generated
	 */
	EDataType getGma();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.GeoReferenzObjekt <em>Geo Referenz Objekt</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Geo Referenz Objekt</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.GeoReferenzObjekt
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.GeoReferenzObjekt"
	 * @generated
	 */
	EDataType getGeoReferenzObjekt();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt <em>Punkt</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Punkt</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt"
	 * @generated
	 */
	EDataType getPunkt();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY <em>Punkt XY</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Punkt XY</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY"
	 * @generated
	 */
	EDataType getPunktXY();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt <em>Punkt Liegt Auf Linien Objekt</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Punkt Liegt Auf Linien Objekt</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt"
	 * @generated
	 */
	EDataType getPunktLiegtAufLinienObjekt();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie <em>Linie</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Linie</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie"
	 * @generated
	 */
	EDataType getLinie();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.LinieXY <em>Linie XY</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Linie XY</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.LinieXY
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.LinieXY"
	 * @generated
	 */
	EDataType getLinieXY();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.BestehtAusLinienObjekten <em>Besteht Aus Linien Objekten</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Besteht Aus Linien Objekten</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.BestehtAusLinienObjekten
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.BestehtAusLinienObjekten"
	 * @generated
	 */
	EDataType getBestehtAusLinienObjekten();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche <em>Flaeche</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Flaeche</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche"
	 * @generated
	 */
	EDataType getFlaeche();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.FlaecheXY <em>Flaeche XY</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Flaeche XY</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.FlaecheXY
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.FlaecheXY"
	 * @generated
	 */
	EDataType getFlaecheXY();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex <em>Komplex</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Komplex</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex"
	 * @generated
	 */
	EDataType getKomplex();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.KomplexXY <em>Komplex XY</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Komplex XY</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.KomplexXY
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.KomplexXY"
	 * @generated
	 */
	EDataType getKomplexXY();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung <em>Tmc Verkehrs Meldung</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Tmc Verkehrs Meldung</em>'.
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung
	 * @model instanceClass="de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung"
	 * @generated
	 */
	EDataType getTmcVerkehrsMeldung();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DavbitctrlFactory getDavbitctrlFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '<em>Bild</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getBild()
		 * @generated
		 */
		EDataType BILD = eINSTANCE.getBild();

		/**
		 * The meta object literal for the '<em>Netz</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getNetz()
		 * @generated
		 */
		EDataType NETZ = eINSTANCE.getNetz();

		/**
		 * The meta object literal for the '<em>System Objekt</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getSystemObjekt()
		 * @generated
		 */
		EDataType SYSTEM_OBJEKT = eINSTANCE.getSystemObjekt();

		/**
		 * The meta object literal for the '<em>Mess Querschnitt Allgemein</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getMessQuerschnittAllgemein()
		 * @generated
		 */
		EDataType MESS_QUERSCHNITT_ALLGEMEIN = eINSTANCE
				.getMessQuerschnittAllgemein();

		/**
		 * The meta object literal for the '<em>Fahr Streifen</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getFahrStreifen()
		 * @generated
		 */
		EDataType FAHR_STREIFEN = eINSTANCE.getFahrStreifen();

		/**
		 * The meta object literal for the '<em>Portable Bitmap</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getPortableBitmap()
		 * @generated
		 */
		EDataType PORTABLE_BITMAP = eINSTANCE.getPortableBitmap();

		/**
		 * The meta object literal for the '<em>Strassen Segment</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getStrassenSegment()
		 * @generated
		 */
		EDataType STRASSEN_SEGMENT = eINSTANCE.getStrassenSegment();

		/**
		 * The meta object literal for the '<em>Kreis</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Kreis
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getKreis()
		 * @generated
		 */
		EDataType KREIS = eINSTANCE.getKreis();

		/**
		 * The meta object literal for the '<em>Ortslage</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortslage
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getOrtslage()
		 * @generated
		 */
		EDataType ORTSLAGE = eINSTANCE.getOrtslage();

		/**
		 * The meta object literal for the '<em>Ortsname</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortsname
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getOrtsname()
		 * @generated
		 */
		EDataType ORTSNAME = eINSTANCE.getOrtsname();

		/**
		 * The meta object literal for the '<em>Strassen Knoten</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getStrassenKnoten()
		 * @generated
		 */
		EDataType STRASSEN_KNOTEN = eINSTANCE.getStrassenKnoten();

		/**
		 * The meta object literal for the '<em>Stoerfall Indikator</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getStoerfallIndikator()
		 * @generated
		 */
		EDataType STOERFALL_INDIKATOR = eINSTANCE.getStoerfallIndikator();

		/**
		 * The meta object literal for the '<em>Umfeld Daten Mess Stelle</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getUmfeldDatenMessStelle()
		 * @generated
		 */
		EDataType UMFELD_DATEN_MESS_STELLE = eINSTANCE
				.getUmfeldDatenMessStelle();

		/**
		 * The meta object literal for the '<em>Anzeige Querschnitt</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getAnzeigeQuerschnitt()
		 * @generated
		 */
		EDataType ANZEIGE_QUERSCHNITT = eINSTANCE.getAnzeigeQuerschnitt();

		/**
		 * The meta object literal for the '<em>Gewaesser</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Gewaesser
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getGewaesser()
		 * @generated
		 */
		EDataType GEWAESSER = eINSTANCE.getGewaesser();

		/**
		 * The meta object literal for the '<em>Situation</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getSituation()
		 * @generated
		 */
		EDataType SITUATION = eINSTANCE.getSituation();

		/**
		 * The meta object literal for the '<em>Baustelle</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getBaustelle()
		 * @generated
		 */
		EDataType BAUSTELLE = eINSTANCE.getBaustelle();

		/**
		 * The meta object literal for the '<em>Stau</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getStau()
		 * @generated
		 */
		EDataType STAU = eINSTANCE.getStau();

		/**
		 * The meta object literal for the '<em>Unfall</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Unfall
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getUnfall()
		 * @generated
		 */
		EDataType UNFALL = eINSTANCE.getUnfall();

		/**
		 * The meta object literal for the '<em>Rds Meldung</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getRdsMeldung()
		 * @generated
		 */
		EDataType RDS_MELDUNG = eINSTANCE.getRdsMeldung();

		/**
		 * The meta object literal for the '<em>Ufds Wind Geschwindigkeit Mittel Wert</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitMittelWert
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getUfdsWindGeschwindigkeitMittelWert()
		 * @generated
		 */
		EDataType UFDS_WIND_GESCHWINDIGKEIT_MITTEL_WERT = eINSTANCE
				.getUfdsWindGeschwindigkeitMittelWert();

		/**
		 * The meta object literal for the '<em>Ufds Wind Geschwindigkeit Spitzen Wert</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitSpitzenWert
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getUfdsWindGeschwindigkeitSpitzenWert()
		 * @generated
		 */
		EDataType UFDS_WIND_GESCHWINDIGKEIT_SPITZEN_WERT = eINSTANCE
				.getUfdsWindGeschwindigkeitSpitzenWert();

		/**
		 * The meta object literal for the '<em>Ufds Wind Richtung</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindRichtung
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getUfdsWindRichtung()
		 * @generated
		 */
		EDataType UFDS_WIND_RICHTUNG = eINSTANCE.getUfdsWindRichtung();

		/**
		 * The meta object literal for the '<em>Vba Event</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getVbaEvent()
		 * @generated
		 */
		EDataType VBA_EVENT = eINSTANCE.getVbaEvent();

		/**
		 * The meta object literal for the '<em>Gma</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.Gma
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getGma()
		 * @generated
		 */
		EDataType GMA = eINSTANCE.getGma();

		/**
		 * The meta object literal for the '<em>Geo Referenz Objekt</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.GeoReferenzObjekt
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getGeoReferenzObjekt()
		 * @generated
		 */
		EDataType GEO_REFERENZ_OBJEKT = eINSTANCE.getGeoReferenzObjekt();

		/**
		 * The meta object literal for the '<em>Punkt</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getPunkt()
		 * @generated
		 */
		EDataType PUNKT = eINSTANCE.getPunkt();

		/**
		 * The meta object literal for the '<em>Punkt XY</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getPunktXY()
		 * @generated
		 */
		EDataType PUNKT_XY = eINSTANCE.getPunktXY();

		/**
		 * The meta object literal for the '<em>Punkt Liegt Auf Linien Objekt</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getPunktLiegtAufLinienObjekt()
		 * @generated
		 */
		EDataType PUNKT_LIEGT_AUF_LINIEN_OBJEKT = eINSTANCE
				.getPunktLiegtAufLinienObjekt();

		/**
		 * The meta object literal for the '<em>Linie</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getLinie()
		 * @generated
		 */
		EDataType LINIE = eINSTANCE.getLinie();

		/**
		 * The meta object literal for the '<em>Linie XY</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.LinieXY
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getLinieXY()
		 * @generated
		 */
		EDataType LINIE_XY = eINSTANCE.getLinieXY();

		/**
		 * The meta object literal for the '<em>Besteht Aus Linien Objekten</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.BestehtAusLinienObjekten
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getBestehtAusLinienObjekten()
		 * @generated
		 */
		EDataType BESTEHT_AUS_LINIEN_OBJEKTEN = eINSTANCE
				.getBestehtAusLinienObjekten();

		/**
		 * The meta object literal for the '<em>Flaeche</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getFlaeche()
		 * @generated
		 */
		EDataType FLAECHE = eINSTANCE.getFlaeche();

		/**
		 * The meta object literal for the '<em>Flaeche XY</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.FlaecheXY
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getFlaecheXY()
		 * @generated
		 */
		EDataType FLAECHE_XY = eINSTANCE.getFlaecheXY();

		/**
		 * The meta object literal for the '<em>Komplex</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getKomplex()
		 * @generated
		 */
		EDataType KOMPLEX = eINSTANCE.getKomplex();

		/**
		 * The meta object literal for the '<em>Komplex XY</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.KomplexXY
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getKomplexXY()
		 * @generated
		 */
		EDataType KOMPLEX_XY = eINSTANCE.getKomplexXY();

		/**
		 * The meta object literal for the '<em>Tmc Verkehrs Meldung</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung
		 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl.DavbitctrlPackageImpl#getTmcVerkehrsMeldung()
		 * @generated
		 */
		EDataType TMC_VERKEHRS_MELDUNG = eINSTANCE.getTmcVerkehrsMeldung();

	}

} //DavbitctrlPackage
