/**
 * BitCtrl Rahmenwerk Plug-in
 * Copyright (C) 2010 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * WeiÃenfelser StraÃe 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl;

import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import com.bitctrl.lib.eclipse.emf.davbitctrl.model.DavbitctrlFactory;
import com.bitctrl.lib.eclipse.emf.davbitctrl.model.DavbitctrlPackage;

import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap;
import de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Gewaesser;
import de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Kreis;
import de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortslage;
import de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortsname;
import de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.BestehtAusLinienObjekten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.FlaecheXY;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.GeoReferenzObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.KomplexXY;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.LinieXY;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.Gma;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitMittelWert;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitSpitzenWert;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindRichtung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Unfall;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class DavbitctrlPackageImpl extends EPackageImpl
		implements DavbitctrlPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType bildEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType netzEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType systemObjektEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType messQuerschnittAllgemeinEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType fahrStreifenEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType portableBitmapEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType strassenSegmentEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType kreisEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType ortslageEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType ortsnameEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType strassenKnotenEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType stoerfallIndikatorEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType umfeldDatenMessStelleEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType anzeigeQuerschnittEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType gewaesserEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType situationEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType baustelleEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType stauEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType unfallEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType rdsMeldungEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType ufdsWindGeschwindigkeitMittelWertEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType ufdsWindGeschwindigkeitSpitzenWertEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType ufdsWindRichtungEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType vbaEventEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType gmaEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType geoReferenzObjektEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType punktEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType punktXYEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType punktLiegtAufLinienObjektEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType linieEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType linieXYEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType bestehtAusLinienObjektenEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType flaecheEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType flaecheXYEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType komplexEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType komplexXYEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType tmcVerkehrsMeldungEDataType = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see com.bitctrl.lib.eclipse.emf.davbitctrl.model.DavbitctrlPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private DavbitctrlPackageImpl() {
		super(eNS_URI, DavbitctrlFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model,
	 * and for any others upon which it depends.
	 * 
	 * <p>
	 * This method is used to initialize {@link DavbitctrlPackage#eINSTANCE}
	 * when that field is accessed. Clients should not invoke it directly.
	 * Instead, they should simply access that field to obtain the package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static DavbitctrlPackage init() {
		if (isInited)
			return (DavbitctrlPackage) EPackage.Registry.INSTANCE
					.getEPackage(DavbitctrlPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredDavbitctrlPackage = EPackage.Registry.INSTANCE
				.get(eNS_URI);
		DavbitctrlPackageImpl theDavbitctrlPackage = registeredDavbitctrlPackage instanceof DavbitctrlPackageImpl
				? (DavbitctrlPackageImpl) registeredDavbitctrlPackage
				: new DavbitctrlPackageImpl();

		isInited = true;

		// Create package meta-data objects
		theDavbitctrlPackage.createPackageContents();

		// Initialize created meta-data
		theDavbitctrlPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theDavbitctrlPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(DavbitctrlPackage.eNS_URI,
				theDavbitctrlPackage);
		return theDavbitctrlPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getBild() {
		return bildEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getNetz() {
		return netzEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getSystemObjekt() {
		return systemObjektEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getMessQuerschnittAllgemein() {
		return messQuerschnittAllgemeinEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getFahrStreifen() {
		return fahrStreifenEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getPortableBitmap() {
		return portableBitmapEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getStrassenSegment() {
		return strassenSegmentEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getKreis() {
		return kreisEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getOrtslage() {
		return ortslageEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getOrtsname() {
		return ortsnameEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getStrassenKnoten() {
		return strassenKnotenEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getStoerfallIndikator() {
		return stoerfallIndikatorEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getUmfeldDatenMessStelle() {
		return umfeldDatenMessStelleEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getAnzeigeQuerschnitt() {
		return anzeigeQuerschnittEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getGewaesser() {
		return gewaesserEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getSituation() {
		return situationEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getBaustelle() {
		return baustelleEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getStau() {
		return stauEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getUnfall() {
		return unfallEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getRdsMeldung() {
		return rdsMeldungEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getUfdsWindGeschwindigkeitMittelWert() {
		return ufdsWindGeschwindigkeitMittelWertEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getUfdsWindGeschwindigkeitSpitzenWert() {
		return ufdsWindGeschwindigkeitSpitzenWertEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getUfdsWindRichtung() {
		return ufdsWindRichtungEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getVbaEvent() {
		return vbaEventEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getGma() {
		return gmaEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getGeoReferenzObjekt() {
		return geoReferenzObjektEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getPunkt() {
		return punktEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getPunktXY() {
		return punktXYEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getPunktLiegtAufLinienObjekt() {
		return punktLiegtAufLinienObjektEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getLinie() {
		return linieEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getLinieXY() {
		return linieXYEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getBestehtAusLinienObjekten() {
		return bestehtAusLinienObjektenEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getFlaeche() {
		return flaecheEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getFlaecheXY() {
		return flaecheXYEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getKomplex() {
		return komplexEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getKomplexXY() {
		return komplexXYEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getTmcVerkehrsMeldung() {
		return tmcVerkehrsMeldungEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DavbitctrlFactory getDavbitctrlFactory() {
		return (DavbitctrlFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated)
			return;
		isCreated = true;

		// Create data types
		bildEDataType = createEDataType(BILD);
		netzEDataType = createEDataType(NETZ);
		systemObjektEDataType = createEDataType(SYSTEM_OBJEKT);
		messQuerschnittAllgemeinEDataType = createEDataType(
				MESS_QUERSCHNITT_ALLGEMEIN);
		fahrStreifenEDataType = createEDataType(FAHR_STREIFEN);
		portableBitmapEDataType = createEDataType(PORTABLE_BITMAP);
		strassenSegmentEDataType = createEDataType(STRASSEN_SEGMENT);
		kreisEDataType = createEDataType(KREIS);
		ortslageEDataType = createEDataType(ORTSLAGE);
		ortsnameEDataType = createEDataType(ORTSNAME);
		strassenKnotenEDataType = createEDataType(STRASSEN_KNOTEN);
		stoerfallIndikatorEDataType = createEDataType(STOERFALL_INDIKATOR);
		umfeldDatenMessStelleEDataType = createEDataType(
				UMFELD_DATEN_MESS_STELLE);
		anzeigeQuerschnittEDataType = createEDataType(ANZEIGE_QUERSCHNITT);
		gewaesserEDataType = createEDataType(GEWAESSER);
		situationEDataType = createEDataType(SITUATION);
		baustelleEDataType = createEDataType(BAUSTELLE);
		stauEDataType = createEDataType(STAU);
		unfallEDataType = createEDataType(UNFALL);
		rdsMeldungEDataType = createEDataType(RDS_MELDUNG);
		ufdsWindGeschwindigkeitMittelWertEDataType = createEDataType(
				UFDS_WIND_GESCHWINDIGKEIT_MITTEL_WERT);
		ufdsWindGeschwindigkeitSpitzenWertEDataType = createEDataType(
				UFDS_WIND_GESCHWINDIGKEIT_SPITZEN_WERT);
		ufdsWindRichtungEDataType = createEDataType(UFDS_WIND_RICHTUNG);
		vbaEventEDataType = createEDataType(VBA_EVENT);
		gmaEDataType = createEDataType(GMA);
		geoReferenzObjektEDataType = createEDataType(GEO_REFERENZ_OBJEKT);
		punktEDataType = createEDataType(PUNKT);
		punktXYEDataType = createEDataType(PUNKT_XY);
		punktLiegtAufLinienObjektEDataType = createEDataType(
				PUNKT_LIEGT_AUF_LINIEN_OBJEKT);
		linieEDataType = createEDataType(LINIE);
		linieXYEDataType = createEDataType(LINIE_XY);
		bestehtAusLinienObjektenEDataType = createEDataType(
				BESTEHT_AUS_LINIEN_OBJEKTEN);
		flaecheEDataType = createEDataType(FLAECHE);
		flaecheXYEDataType = createEDataType(FLAECHE_XY);
		komplexEDataType = createEDataType(KOMPLEX);
		komplexXYEDataType = createEDataType(KOMPLEX_XY);
		tmcVerkehrsMeldungEDataType = createEDataType(TMC_VERKEHRS_MELDUNG);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized)
			return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Initialize data types
		initEDataType(bildEDataType, Bild.class, "Bild", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(netzEDataType, Netz.class, "Netz", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(systemObjektEDataType, SystemObjekt.class, "SystemObjekt",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(messQuerschnittAllgemeinEDataType,
				MessQuerschnittAllgemein.class, "MessQuerschnittAllgemein",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(fahrStreifenEDataType, FahrStreifen.class, "FahrStreifen",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(portableBitmapEDataType, PortableBitMap.class,
				"PortableBitmap", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(strassenSegmentEDataType, StrassenSegment.class,
				"StrassenSegment", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(kreisEDataType, Kreis.class, "Kreis", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(ortslageEDataType, Ortslage.class, "Ortslage",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(ortsnameEDataType, Ortsname.class, "Ortsname",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(strassenKnotenEDataType, StrassenKnoten.class,
				"StrassenKnoten", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(stoerfallIndikatorEDataType, StoerfallIndikator.class,
				"StoerfallIndikator", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(umfeldDatenMessStelleEDataType,
				UmfeldDatenMessStelle.class, "UmfeldDatenMessStelle",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(anzeigeQuerschnittEDataType, AnzeigeQuerschnitt.class,
				"AnzeigeQuerschnitt", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(gewaesserEDataType, Gewaesser.class, "Gewaesser",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(situationEDataType, Situation.class, "Situation",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(baustelleEDataType, Baustelle.class, "Baustelle",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(stauEDataType, Stau.class, "Stau", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(unfallEDataType, Unfall.class, "Unfall", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(rdsMeldungEDataType, RdsMeldung.class, "RdsMeldung",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(ufdsWindGeschwindigkeitMittelWertEDataType,
				UfdsWindGeschwindigkeitMittelWert.class,
				"UfdsWindGeschwindigkeitMittelWert", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(ufdsWindGeschwindigkeitSpitzenWertEDataType,
				UfdsWindGeschwindigkeitSpitzenWert.class,
				"UfdsWindGeschwindigkeitSpitzenWert", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(ufdsWindRichtungEDataType, UfdsWindRichtung.class,
				"UfdsWindRichtung", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(vbaEventEDataType, VbaEvent.class, "VbaEvent",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(gmaEDataType, Gma.class, "Gma", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(geoReferenzObjektEDataType, GeoReferenzObjekt.class,
				"GeoReferenzObjekt", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(punktEDataType, Punkt.class, "Punkt", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(punktXYEDataType, PunktXY.class, "PunktXY",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(punktLiegtAufLinienObjektEDataType,
				PunktLiegtAufLinienObjekt.class, "PunktLiegtAufLinienObjekt",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(linieEDataType, Linie.class, "Linie", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(linieXYEDataType, LinieXY.class, "LinieXY",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(bestehtAusLinienObjektenEDataType,
				BestehtAusLinienObjekten.class, "BestehtAusLinienObjekten",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(flaecheEDataType, Flaeche.class, "Flaeche",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(flaecheXYEDataType, FlaecheXY.class, "FlaecheXY",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(komplexEDataType, Komplex.class, "Komplex",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(komplexXYEDataType, KomplexXY.class, "KomplexXY",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(tmcVerkehrsMeldungEDataType, TmcVerkehrsMeldung.class,
				"TmcVerkehrsMeldung", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);
	}

} // DavbitctrlPackageImpl
