package com.bitctrl.lib.eclipse.gef;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

/**
 * Basisklasse für Edit Parts, deren Kinder in einem bestimmten Layer
 * gezeichnet werden sollen. Die Kind-Edit-Parts müssen die Schnittstelle
 * {@link ILayeredGraphicalEditPart} implementieren.
 *
 * <p>
 * Soll dieses Edit Part selbst in einem bestimmten Layer gezeichnet werden,
 * muss es {@link ILayeredGraphicalEditPart} selbst implementieren und das
 * Eltern-Edit-Part muss dann auch ein {@link AbstractLayerGraphicalEditPart}
 * sein.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @version $Id$
 */
public abstract class AbstractLayerGraphicalEditPart
		extends AbstractGraphicalEditPart {

	/**
	 * Wenn das Child ein {@link ILayeredGraphicalEditPart} ist, dann wird es in
	 * den gewünschten Layer gelegt.
	 */
	@Override
	protected void addChildVisual(final EditPart childEditPart,
			final int index) {
		// // XXX Wie den Index des Childs beachten?
		// if (childEditPart instanceof ILayeredGraphicalEditPart) {
		// final ILayeredGraphicalEditPart editPart =
		// (ILayeredGraphicalEditPart) childEditPart;
		// final IFigure layer = editPart.getLayer();
		// if (layer != null) {
		// // layer.add(editPart.getFigure(), index);
		// layer.add(editPart.getFigure());
		// return;
		// }
		// }
		//
		// // Fallback
		// // super.addChildVisual(childEditPart, index);
		// final IFigure child = ((GraphicalEditPart)
		// childEditPart).getFigure();
		// getContentPane().add(child);

		IFigure destination = getContentPane();
		if (childEditPart instanceof ILayeredGraphicalEditPart) {
			final ILayeredGraphicalEditPart editPart = (ILayeredGraphicalEditPart) childEditPart;
			final IFigure layer = editPart.getLayer();
			if (layer != null) {
				destination = layer;
			}
		}

		if (destination != null) {

			final IFigure child = ((GraphicalEditPart) childEditPart)
					.getFigure();

			if (child != null) {
				IFigure successor = null;
				for (final Object obj : getChildren().subList(index,
						getChildren().size())) {
					if (obj instanceof GraphicalEditPart) {
						if (obj != childEditPart
								&& destination.equals(((GraphicalEditPart) obj)
										.getFigure().getParent())) {
							successor = ((GraphicalEditPart) obj).getFigure();
							break;
						}
					}
				}

				if (successor == null) {
					destination.add(child);
				} else {
					destination.add(child,
							destination.getChildren().indexOf(successor));
				}
			}
		}
	}

	/**
	 * Wenn das Child ein {@link ILayeredGraphicalEditPart} ist, dann wird es
	 * aus den dort festgelegten Layer entfernt.
	 */
	@Override
	protected void removeChildVisual(final EditPart childEditPart) {
		if (childEditPart instanceof ILayeredGraphicalEditPart) {
			final ILayeredGraphicalEditPart editPart = (ILayeredGraphicalEditPart) childEditPart;
			final IFigure layer = editPart.getLayer();
			if (layer != null) {
				layer.remove(editPart.getFigure());
			}
			return;
		}

		// Fallback
		super.removeChildVisual(childEditPart);
	}

	/**
	 * Gibt den Layer Manager zurück.
	 *
	 * @return der Layer Manager oder <code>null</code>, wenn keiner existiert.
	 */
	protected ILayerManager getLayerManager() {
		return (ILayerManager) getViewer()
				.getProperty(ILayerManager.class.getName());
	}

}
