package com.bitctrl.lib.eclipse.gef;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * Plug-in zur Erweiterung der Funktionalität von GEF.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @version $Id$
 */
public class GefPlugin extends AbstractUIPlugin {

	/** Die ID des Plug-ins. */
	public static final String PLUGIN_ID = "com.bitctrl.lib.eclipse.gef"; //$NON-NLS-1$

	private static GefPlugin instance;

	/**
	 * Gibt die gemeinsame Instanz des Plug-ins zurück.
	 *
	 * @return die Plug-in-Instanz oder <code>null</code>, wenn das Plug-in
	 *         nicht gestartet ist.
	 */
	public static GefPlugin getDefault() {
		return instance;
	}

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		instance = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		instance = null;
		super.stop(context);
	}

	/**
	 * Gibt den Image Descriptor zu einem Bild im Plug-in zurück.
	 *
	 * @param imageFilePath
	 *            der Pfad zum Bild, relativ zum Plug-in.
	 * @return der Image Descriptor des gesuchten Bildes oder <code>null</code>,
	 *         wenn zu dem Pfad kein Bild existiert.
	 */
	public ImageDescriptor getImageDescriptor(final String imageFilePath) {
		return imageDescriptorFromPlugin(PLUGIN_ID, imageFilePath);
	}

}
