package com.bitctrl.lib.eclipse.gef;

import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.editparts.LayerManager;

/**
 * Erweitert den {@link LayerManager} zu einem echten Layer Manager.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @version $Id$
 */
public interface ILayerManager extends LayerManager {

	/** Konstante für das Ändern der Reihenfolge der Layer. */
	enum Direction {
	Up, Down, Top, Bottom;
	}

	/**
	 * Registriert einen Listener auf Layeränderungen.
	 *
	 * @param l
	 *            der Listener.
	 */
	void addLayerListener(LayerListener l);

	/**
	 * Registriert einen Listener auf Änderungen an einem bestimmten Layer.
	 *
	 * @param l
	 *            der Listener.
	 * @param key
	 *            der zu überwachende Layer.
	 */
	void addLayerListener(LayerListener l, Object key);

	/**
	 * Deregistriert einen Listener auf Layeränderungen.
	 *
	 * @param l
	 *            der Listener.
	 */
	void removeLayerListener(LayerListener l);

	/**
	 * Deregistriert einen Listener auf Änderungen an einem bestimmten Layer.
	 *
	 * @param l
	 *            der Listener.
	 * @param key
	 *            der nicht mehr zu überwachende Layer.
	 */
	void removeLayerListener(LayerListener l, Object key);

	/**
	 * Gibt alle Schlüssel der zu verwaltenden benutzerdefinierten Layer
	 * zurück.
	 *
	 * @return die Liste der Schlüssel der benutzerdefinierten Layer.
	 */
	public abstract List<?> getCustomLayerKeys();

	/**
	 * Fügt eine benutzerdefinierte Layer als oberste Layer hinzu.
	 *
	 * @param key
	 *            der Schlüssel des neuen Layers.
	 * @param layer
	 *            der neue Layer.
	 */
	public abstract void addCustomLayer(final Object key, final IFigure layer);

	/**
	 * Fügt eine benutzerdefinierte Layer an einer bestimmten Position hinzu.
	 *
	 * @param key
	 *            der Schlüssel des neuen Layers.
	 * @param layer
	 *            der neue Layer.
	 * @param index
	 *            die Position des neuen Layers.
	 */
	public abstract void addCustomLayer(final Object key, final IFigure layer,
			final int index);

	/**
	 * Entfernt einen benutzerdefinierte Layer.
	 *
	 * @param key
	 *            der zu entfernende Layer.
	 */
	public abstract void removeCustomLayer(final Object key);

	/**
	 * Prüft, ob ein Layer sichtbar ist.
	 *
	 * @param key
	 *            der Schlüssel des zu prüfenden Layers.
	 * @return <code>true</code>, wenn der Layer, der zu dem Schlüssel gehört
	 *         sichtbar ist, sonst <code>false</code>.
	 */

	public abstract boolean isVisble(final Object key);

	/**
	 * Legt die Sichtbarkeit eines Layers fest.
	 *
	 * @param key
	 *            der Schlüssel des Layers, desses Sichtbarkeit geändert
	 *            werden soll.
	 * @param visible
	 *            <code>true</code>, wenn der Layer sichtbar werden soll und
	 *            <code>false</code>, wenn der Layer ausgeblendet werden soll.
	 */
	public abstract void setVisble(final Object key, final boolean visible);

	/**
	 * Prüft ob ein Layer verschoben werden kann. Dies kann z.&nbsp;B. genutzt,
	 * um entsprechende Actions in der GUI zu aktivieren oder deaktivieren.
	 *
	 * @param key
	 *            der Schlüssel des Layers, der verschoben werden soll.
	 * @param direction
	 *            die Richtung in die verschoben werden soll.
	 * @return <code>true</code>, wenn die Verschibung möglich ist, sonst
	 *         <code>false</code>.
	 */
	public abstract boolean canMove(final Object key,
			final Direction direction);

	/**
	 * Ändert die Reihenfolge der Layer.
	 *
	 * <p>
	 * Kann die geforderte Operation nicht durchgeführt werden, passiert
	 * nichts. Das kann z.&nbsp;B. der Fall sein, wenn der oberste Layer noch
	 * eins nach oben verschoben werden soll.
	 *
	 * @param key
	 *            der Schlüssel des Layers, der verschoben werden soll.
	 * @param direction
	 *            die Richtung in die verschoben werden soll.
	 */
	public abstract void move(final Object key, final Direction direction);

	/**
	 * Gibt den aktuellen Alphawert eines Layers zurück. Der Wert liegt
	 * zwischen 0 und 255, wobei 0 für vollständig transparent steht.
	 *
	 * @param key
	 *            der Schlüssel des Layers, dessen Alphawert gesucht ist.
	 * @return ein Wert zwischen 0 und 255 oder -1, wenn der Layer keinen
	 *         Alphawert unterstützt.
	 */
	public abstract int getAlpha(final Object key);

	/**
	 * Legt den Alphawert für einen Layer fest. Unterstützt der Layer keinen
	 * Alphawert, dann passiert nichts.
	 *
	 * @param key
	 *            der Schlüssel des Layers, dessen Alphawert geändert werden
	 *            soll.
	 * @param alpha
	 *            der neue Alphawert muss zwischen 0 und 255 liegen, 0 bedeutet
	 *            vollständig transparent.
	 */
	public abstract void setAlpha(final Object key, final int alpha);

}