package com.bitctrl.lib.eclipse.gef;

import java.util.EventObject;

public class LayerEvent extends EventObject {

	public static final int ADDED = 1;
	public static final int REMOVED = 2;
	public static final int MOVED = 4;
	public static final int VISIBLE = 8;
	public static final int ALPHA = 16;

	private final Object layer;
	private final int eventType;
	private boolean visible;
	private int alpha;

	public LayerEvent(final ILayerManager source, final int eventType,
			final Object layer) {
		super(source);
		this.eventType = eventType;
		this.layer = layer;
	}

	public ILayerManager getLayerManager() {
		return (ILayerManager) super.getSource();
	}

	public int getEventType() {
		return eventType;
	}

	public Object getLayer() {
		return layer;
	}

	public boolean isVisible() {
		return visible;
	}

	public void setVisible(final boolean visible) {
		this.visible = visible;
	}

	public int getAlpha() {
		return alpha;
	}

	public void setAlpha(final int alpha) {
		this.alpha = alpha;
	}

}
