package com.bitctrl.lib.eclipse.gef.editparts;

import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.TreeItem;

/**
 * Erweitert den Tree Edit Part um Vorder- und Hintergrundfarbe.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @version $Id$
 */
public abstract class AbstractColoredTreeEditPart extends AbstractTreeEditPart {

	/**
	 * Der Standardkonstruktor tut nix.
	 */
	public AbstractColoredTreeEditPart() {
		// tut nix
	}

	/**
	 * Initialisiert den Tree Edit Part.
	 *
	 * @param model
	 *            das Modellobjekt.
	 */
	public AbstractColoredTreeEditPart(final Object model) {
		setModel(model);
	}

	/**
	 * Überschreiben um die Vordergrundfarbe für das Widget festzulegen.
	 *
	 * <p>
	 * Die Defaultimplementierung gibt <code>null</code> zurück.
	 *
	 * @return eine Farbe oder <code>null</code> für die Standardfarbe.
	 */
	protected Color getForeground() {
		return null;
	}

	/**
	 * Überschreiben um die Hintergrundgrundfarbe für das Widget festzulegen.
	 *
	 * <p>
	 * Die Defaultimplementierung gibt <code>null</code> zurück.
	 *
	 * @return eine Farbe oder <code>null</code> für die Standardfarbe.
	 */
	protected Color getBackground() {
		return null;
	}

	/**
	 * Setzt zusätzlich Vorder- und Hintergrundfarbe für das Widget. Um die
	 * Farbe zu setzen, sollte {@link #getForeground()} und
	 * {@link #getBackground()} überschrieben werden.
	 */
	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		setWidgetForeground(getForeground());
		setWidgetBackground(getBackground());
	}

	/**
	 * Legt den die Vordergrundfarbe fest.
	 *
	 * @param color
	 */
	protected final void setWidgetForeground(final Color color) {
		if (checkTreeItem()) {
			((TreeItem) getWidget()).setForeground(color);
		}
	}

	/**
	 * Legt die Hintergrundfarbe fest.
	 *
	 * @param color
	 */
	protected final void setWidgetBackground(final Color color) {
		if (checkTreeItem()) {
			((TreeItem) getWidget()).setBackground(color);
		}
	}

}
