package com.bitctrl.lib.eclipse.gef.editpolicies;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.tools.SelectEditPartTracker;

/**
 * Policy, die nur die Selektion erlaubt, aber weder Verschieben noch das
 * Ändern der Größe.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @version $Id$
 */
public class OnlySelectionEditPolicy extends SelectionHandlesEditPolicy {

	/**
	 * Handler, der ein gelbes halbtransparentes Rechteck um die {@link Figure}
	 * eines {@link GraphicalEditPart}s zeichnet.
	 *
	 * @author Christian Hoesel, BitCtrl Systems GmbH 2010
	 * @version $Id$
	 *
	 */
	public class DavSelectionHandler extends MoveHandle {

		/**
		 * Konstruktor.
		 *
		 * @param owner
		 * @see MoveHandle#MoveHandle(GraphicalEditPart)
		 */
		public DavSelectionHandler(final GraphicalEditPart owner) {
			super(owner);
		}

		@Override
		protected void initialize() {
			setOpaque(false);
			final LineBorder b = new LineBorder(8) {
				@Override
				public void paint(final IFigure figure, final Graphics g,
						final Insets insets) {

					// g.pushState();
					g.setAlpha(180);
					super.paint(figure, g, insets);
					// g.popState();
				}
			};
			b.setColor(ColorConstants.yellow);
			setBorder(b);
		}

	}

	@Override
	protected List<?> createSelectionHandles() {
		final List<Object> list = new ArrayList<Object>();
		// list.add(new DavSelectionHandler((GraphicalEditPart) getHost()));
		NonResizableHandleKit.addHandles((GraphicalEditPart) getHost(), list,
				new SelectEditPartTracker(getHost()), Cursors.ARROW);
		return list;
	}

}
