/**
 *
 */
package com.bitctrl.lib.eclipse.gef.editpolicies;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.SquareHandle;

import com.bitctrl.lib.eclipse.gef.handles.BendpointCreationHandle;
import com.bitctrl.lib.eclipse.gef.handles.BendpointMoveHandle;
import com.bitctrl.lib.eclipse.gef.requests.BendpointRequest;

public abstract class PolylineEditPolicy extends SelectionHandlesEditPolicy
		implements PropertyChangeListener {

	private boolean isDeleting = false;
	private boolean isCreatingMidpoint = false;

	@Override
	public void activate() {
		super.activate();
		getPolyline().addPropertyChangeListener("points", this);
	}

	@Override
	protected List<SquareHandle> createSelectionHandles() {
		final List<SquareHandle> list = new ArrayList<SquareHandle>();
		final PointList points = getPolyline().getPoints();
		for (int i = 0; i < points.size(); ++i) {
			list.add(new BendpointMoveHandle((GraphicalEditPart) getHost(), i,
					i));

			if (i < points.size() - 1) {
				list.add(new BendpointCreationHandle(
						(GraphicalEditPart) getHost(), i, i));
			}
		}
		return list;
	}

	@Override
	public void deactivate() {
		getPolyline().removePropertyChangeListener("points", this);
		super.deactivate();
	}

	protected void eraseConnectionFeedback(final BendpointRequest request) {
		// TODO Auto-generated method stub
		isCreatingMidpoint = false;
	}

	@Override
	public void eraseSourceFeedback(final Request request) {
		if (REQ_MOVE_BENDPOINT.equals(request.getType())
				|| REQ_CREATE_BENDPOINT.equals(request.getType())) {
			eraseConnectionFeedback((BendpointRequest) request);
		}
	}

	@Override
	public Command getCommand(final Request request) {
		if (REQ_MOVE_BENDPOINT.equals(request.getType())) {
			if (isDeleting) {
				return getDeleteBendpointCommand((BendpointRequest) request);
			}
			return getMoveBendpointCommand((BendpointRequest) request);
		}
		if (REQ_CREATE_BENDPOINT.equals(request.getType())) {
			return getCreateBendpointCommand((BendpointRequest) request);
		}
		return null;
	}

	protected AbstractPointListShape getPolyline() {
		return (AbstractPointListShape) ((GraphicalEditPart) getHost())
				.getFigure();
	}

	protected abstract Command getCreateBendpointCommand(
			BendpointRequest request);

	protected abstract Command getDeleteBendpointCommand(
			BendpointRequest request);

	protected abstract Command getMoveBendpointCommand(
			BendpointRequest request);

	private boolean lineContainsPoint(final Point p1, final Point p2,
			final Point p) {
		final int tolerance = 7;
		final Rectangle rect = Rectangle.SINGLETON;
		rect.setSize(0, 0);
		rect.setLocation(p1.x, p1.y);
		rect.union(p2.x, p2.y);
		rect.expand(tolerance, tolerance);
		if (!rect.contains(p.x, p.y)) {
			return false;
		}

		int v1x, v1y, v2x, v2y;
		int numerator, denominator;
		double result = 0.0;

		if (p1.x != p2.x && p1.y != p2.y) {

			v1x = p2.x - p1.x;
			v1y = p2.y - p1.y;
			v2x = p.x - p1.x;
			v2y = p.y - p1.y;

			numerator = v2x * v1y - v1x * v2y;
			denominator = v1x * v1x + v1y * v1y;

			result = (numerator << 10) / denominator * numerator >> 10;
		}

		// if it is the same point, and it passes the bounding box test,
		// the result is always true.
		return result <= tolerance * tolerance;
	}

	@Override
	public void propertyChange(final PropertyChangeEvent evt) {
		// $TODO optimize so that handles aren't added constantly.
		if (getHost().getSelected() != EditPart.SELECTED_NONE) {
			addSelectionHandles();
		}
	}

	protected void showCreateBendpointFeedback(final BendpointRequest request) {
		final AbstractPointListShape polyline = getPolyline();
		final PointList points = polyline.getPoints().getCopy();
		if (!isCreatingMidpoint) {
			points.insertPoint(request.getLocation(), request.getIndex() + 1);
			isCreatingMidpoint = true;
		} else {
			points.setPoint(request.getLocation(), request.getIndex() + 1);
		}
		polyline.setPoints(points);
	}

	protected void showDeleteBendpointFeedback(final BendpointRequest request) {
		final AbstractPointListShape polyline = getPolyline();
		final PointList points = polyline.getPoints().getCopy();
		points.removePoint(request.getIndex());
		polyline.setPoints(points);
	}

	protected void showMoveBendpointFeedback(final BendpointRequest request) {
		final AbstractPointListShape polyline = getPolyline();
		final PointList points = polyline.getPoints().getCopy();
		if (request.getIndex() + 1 < points.size() && request.getIndex() > 0
				&& lineContainsPoint(points.getPoint(request.getIndex() - 1),
						points.getPoint(request.getIndex() + 1),
						request.getLocation())) {
			isDeleting = true;
			showDeleteBendpointFeedback(request);
		} else {
			isDeleting = false;
			points.setPoint(request.getLocation(), request.getIndex());
			polyline.setPoints(points);
		}
	}

	@Override
	public void showSourceFeedback(final Request request) {
		if (REQ_MOVE_BENDPOINT.equals(request.getType())) {
			showMoveBendpointFeedback((BendpointRequest) request);
		} else if (REQ_CREATE_BENDPOINT.equals(request.getType())) {
			showCreateBendpointFeedback((BendpointRequest) request);
		}
	}

}
