package com.bitctrl.lib.eclipse.gef.handles;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RequestConstants;

import com.bitctrl.lib.eclipse.draw2d.MidpointLocator;
import com.bitctrl.lib.eclipse.gef.tools.PolylineBendpointTracker;

/**
 * Handler für das Erzeugen eines neuen Punktes einer Polylinie.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @version $Id$
 */
public class BendpointCreationHandle extends PolylineHandle {

	{
		setCursor(Cursors.SIZEALL);
		setPreferredSize(new Dimension(DEFAULT_HANDLE_SIZE - 2,
				DEFAULT_HANDLE_SIZE - 2));
	}

	public BendpointCreationHandle(final GraphicalEditPart owner,
			final int index) {
		super(owner, index);
		setLocator(new MidpointLocator(getPolyline(), index));
	}

	public BendpointCreationHandle(final GraphicalEditPart owner,
			final int index, final int locatorIndex) {
		super(owner, index);
		setLocator(new MidpointLocator(getPolyline(), locatorIndex));
	}

	public BendpointCreationHandle(final GraphicalEditPart owner,
			final int index, final Locator locator) {
		super(owner, index);
		setLocator(locator);
	}

	@Override
	protected DragTracker createDragTracker() {
		PolylineBendpointTracker tracker;
		tracker = new PolylineBendpointTracker(getOwner(), getIndex());
		tracker.setType(RequestConstants.REQ_CREATE_BENDPOINT);
		tracker.setDefaultCursor(getCursor());
		return tracker;
	}

}
