package com.bitctrl.lib.eclipse.gef.handles;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Locator;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RequestConstants;

import com.bitctrl.lib.eclipse.draw2d.BendpointLocator;
import com.bitctrl.lib.eclipse.gef.tools.PolylineBendpointTracker;

/**
 * Handler für das Bewegen eines Punktes einer Polylinie.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @version $Id$
 */
public class BendpointMoveHandle extends PolylineHandle {

	{
		setCursor(Cursors.SIZEALL);
	}

	public BendpointMoveHandle(final GraphicalEditPart owner, final int index) {
		super(owner, index);
		setLocator(new BendpointLocator(getPolyline(), index + 1));
	}

	public BendpointMoveHandle(final GraphicalEditPart owner, final int index,
			final int locatorIndex) {
		super(owner, index);
		setLocator(new BendpointLocator(getPolyline(), locatorIndex));
	}

	public BendpointMoveHandle(final GraphicalEditPart owner, final int index,
			final Locator locator) {
		super(owner, index);
		setLocator(locator);
	}

	@Override
	protected DragTracker createDragTracker() {
		PolylineBendpointTracker tracker;
		tracker = new PolylineBendpointTracker(getOwner(), getIndex());
		tracker.setType(RequestConstants.REQ_MOVE_BENDPOINT);
		tracker.setDefaultCursor(getCursor());
		return tracker;
	}

}
