package com.bitctrl.lib.eclipse.gef.handles;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.Polyline;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.SquareHandle;

/**
 * Basisklasse für Handler, die einen Punkt einer Polylinie manipulieren.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @version $Id$
 */
public abstract class PolylineHandle extends SquareHandle
		implements PropertyChangeListener {

	{
		setCursor(Cursors.CROSS);
	}

	private final int index;

	/**
	 * Der Standardkonstruktor ruft
	 * {@link #PolylineHandle(GraphicalEditPart, int)} ohne Edit Part und mit
	 * dem Index 0 auf.
	 */
	protected PolylineHandle() {
		this(null, 0);
	}

	/**
	 * Initialisiert den Handler.
	 *
	 * @param owner
	 *            der Edit Part zu dem der Handle gehört.
	 * @param index
	 *            der Index des Punktes in der Polylinie.
	 */
	protected PolylineHandle(final GraphicalEditPart owner, final int index) {
		setOwner(owner);
		this.index = index;
	}

	/**
	 * Gibt die Polylinie die manipuliert wird zurück.
	 *
	 * @return die zu manipulierende Polylinie.
	 */
	protected AbstractPointListShape getPolyline() {
		return (AbstractPointListShape) getOwnerFigure();
	}

	/**
	 * Gibt den Index des zu manipulierenden Punktes zurück.
	 *
	 * @return der Index des Punktes in der Polylinie.
	 */
	protected int getIndex() {
		return index;
	}

	/**
	 * Meldet sich als Listener auf die Property <code>points</code> der
	 * Polylinie an.
	 *
	 * <em>Hinweis:</em> Derzeit feuern nur {@link Polyline} und {@link Polygon}
	 * diesesm Event!
	 */
	@Override
	public void addNotify() {
		super.addNotify();
		getPolyline().addPropertyChangeListener("points", this);
	}

	/**
	 * Meldet sich als Listener auf die Property <code>points</code> der
	 * Polylinie ab.
	 *
	 * <em>Hinweis:</em> Derzeit feuern nur {@link Polyline} und {@link Polygon}
	 * diesesm Event!
	 */
	@Override
	public void removeNotify() {
		getPolyline().removePropertyChangeListener("points", this);
		super.removeNotify();
	}

	/**
	 * Invalidiert den Handler bei Änderung der Property <code>points</code>
	 * der Polylinie.
	 */
	@Override
	public void propertyChange(final PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals("points")) {
			revalidate();
		}
	}

}
