package com.bitctrl.lib.eclipse.gef.requests;

import org.eclipse.gef.GraphicalEditPart;

/**
 * A request to alter a bendpoint.
 */
public class BendpointRequest extends org.eclipse.gef.requests.LocationRequest {

	private int index;
	private GraphicalEditPart source;

	/**
	 * Returns the index of the bendpoint to be changed.
	 *
	 * @return the bendpoint index
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * Returns the ConnectionEditPart that the bendpoint belongs to.
	 *
	 * @return the bendpoint's ConnectionEditPart
	 */
	public GraphicalEditPart getSource() {
		return source;
	}

	/**
	 * Sets the index of the bendpoint to be changed.
	 *
	 * @param i
	 *            the bendpoint's index
	 */
	public void setIndex(final int i) {
		index = i;
	}

	/**
	 * Sets the ConnectionEditPart the bendpoint belongs to.
	 *
	 * @param s
	 *            the bendpoint's ConnectionEditPart
	 */
	public void setSource(final GraphicalEditPart s) {
		source = s;
	}

}