package com.bitctrl.lib.eclipse.gef.tools;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.SimpleDragTracker;

import com.bitctrl.lib.eclipse.gef.requests.BendpointRequest;

/**
 * Tracker für das Manipulieren einer Polylinie.
 *
 * @author BitCtrl Systems GmbH, Falko
 * @version $Id$
 */
public class PolylineBendpointTracker extends SimpleDragTracker {

	private Object type;
	private GraphicalEditPart owner;
	private int index;

	/**
	 * Der Standardkonstruktor tut nix.
	 */
	protected PolylineBendpointTracker() {
		// tut nix
	}

	/**
	 * Intialisiert den Tracker mit Edit Part
	 *
	 * @param owner
	 *            der Edit Part zu dem der Tracker gehört und der eine
	 *            Polylinie als Figure besitzt.
	 * @param index
	 *            der Index des zu manipulierenden Punkts der Polylinie.
	 */
	public PolylineBendpointTracker(final GraphicalEditPart owner,
			final int index) {
		setOwner(owner);
		setIndex(index);
	}

	@Override
	protected List<GraphicalEditPart> createOperationSet() {
		final List<GraphicalEditPart> list = new ArrayList<GraphicalEditPart>();
		list.add(getOwner());
		return list;
	}

	@Override
	protected Request createSourceRequest() {
		final BendpointRequest request = new BendpointRequest();
		request.setType(getType());
		request.setIndex(getIndex());
		request.setSource(getOwner());
		return request;
	}

	@Override
	protected void updateSourceRequest() {
		final BendpointRequest request = (BendpointRequest) getSourceRequest();

		final ZoomManager zManager = (ZoomManager) owner.getViewer()
				.getProperty(ZoomManager.class.toString());
		Point location = getLocation().getCopy();
		if (zManager != null) {
			final double d = zManager.getZoom();
			location = location
					.translate(zManager.getViewport().getViewLocation());
			location = location.getScaled(1 / d);
			request.setLocation(location);
		} else {
			request.setLocation(location);
		}

	}

	/**
	 * Leitet den Aufruf an den Edit Part des Trackers weiter.
	 *
	 * @see #getOwner()
	 */
	@Override
	protected Command getCommand() {
		return getOwner().getCommand(getSourceRequest());
	}

	@Override
	protected String getCommandName() {
		return getType().toString();
	}

	@Override
	protected String getDebugName() {
		return "Bendpoint Handle Tracker " + getCommandName();//$NON-NLS-1$
	}

	/**
	 * Gibt die Polylinie zurück, die mit dem Tracker manipuloert wird.
	 *
	 * @return die zu manipulierende Polylinie.
	 */
	protected AbstractPointListShape getPolyline() {
		return (AbstractPointListShape) getOwner().getFigure();
	}

	protected GraphicalEditPart getOwner() {
		return owner;
	}

	public void setOwner(final GraphicalEditPart cep) {
		owner = cep;
	}

	protected int getIndex() {
		return index;
	}

	public void setIndex(final int i) {
		index = i;
	}

	protected Object getType() {
		return type;
	}

	public void setType(final Object type) {
		this.type = type;
	}

}
