package com.bitctrl.lib.eclipse.gef.views;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

import com.bitctrl.lib.eclipse.gef.GefPlugin;
import com.bitctrl.lib.eclipse.gef.ILayerManager;

/**
 * Diese View zeigt die verf�gbaren Layer des aktuellen Editors, falls er den
 * {@link ILayerManager} unterst�tzt, und erlaubt die Verwaltung der Layer.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @version $Id$
 */
public class LayersView extends ViewPart
		implements ICheckStateListener, IPartListener {

	/** Die ID der Ansicht. */
	public static final String VIEW_ID = LayersView.class.getName();

	private final class MoveUpAction extends Action {
		{
			setText("Nach oben");
			setImageDescriptor(GefPlugin.getDefault()
					.getImageDescriptor("icons/go-up.png")); //$NON-NLS-1$
		}

		@Override
		public void run() {
			moveSelected(ILayerManager.Direction.Up);
		}
	}

	private final class MoveDownAction extends Action {
		{
			setText("Nach unten");
			setImageDescriptor(GefPlugin.getDefault()
					.getImageDescriptor("icons/go-down.png")); //$NON-NLS-1$
		}

		@Override
		public void run() {
			moveSelected(ILayerManager.Direction.Down);
		}
	}

	private final class MoveTopAction extends Action {
		{
			setText("Nach ganz oben");
			setImageDescriptor(GefPlugin.getDefault()
					.getImageDescriptor("icons/go-top.png")); //$NON-NLS-1$
		}

		@Override
		public void run() {
			moveSelected(ILayerManager.Direction.Top);
		}
	}

	private final class MoveBottomAction extends Action {
		{
			setText("Nach ganz unten");
			setImageDescriptor(GefPlugin.getDefault()
					.getImageDescriptor("icons/go-bottom.png")); //$NON-NLS-1$
		}

		@Override
		public void run() {
			moveSelected(ILayerManager.Direction.Bottom);
		}
	}

	private CheckboxTableViewer viewer;
	private ILayerManager layerManager;
	private Action moveUpAction;
	private Action moveDownAction;
	private Action moveTopAction;
	private Action moveBottomAction;

	private Group transparenzGroup;

	private Scale transparenz;

	private Label transparenzLabel;

	@Override
	public void createPartControl(final Composite parent) {
		final Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(1, false));

		viewer = CheckboxTableViewer.newCheckList(container,
				SWT.SINGLE | SWT.BORDER);
		viewer.getControl().setLayoutData(
				new GridData(GridData.FILL, GridData.FILL, true, true));
		viewer.setLabelProvider(new LabelProvider());
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.addCheckStateListener(this);
		viewer.getControl().setEnabled(false);

		transparenzGroup = new Group(container, SWT.NONE);
		transparenzGroup.setText("Deckkraft");
		transparenzGroup.setLayoutData(
				new GridData(GridData.FILL, GridData.FILL, true, false));
		transparenzGroup.setLayout(new GridLayout(2, false));

		transparenz = new Scale(transparenzGroup, SWT.NONE);
		transparenz.setMinimum(0);
		transparenz.setMaximum(255);
		transparenz.setSelection(255);
		// transparenz.setIncrement(transparenz.getMaximum() * 2);
		transparenz.setPageIncrement(transparenz.getMaximum() / 4 + 1);
		transparenz.setEnabled(false);

		transparenzLabel = new Label(transparenzGroup, SWT.NONE);
		transparenzLabel.setText("100 %"); //$NON-NLS-1$
		transparenzLabel.setEnabled(false);

		transparenz.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final ISelection selection = viewer.getSelection();
				if (!selection.isEmpty()) {
					final Object selected = ((StructuredSelection) selection)
							.getFirstElement();
					final int alpha = transparenz.getSelection();
					layerManager.setAlpha(selected, alpha);
					final int percentage = alpha * 100
							/ transparenz.getMaximum();
					transparenzLabel.setText(percentage + " %"); //$NON-NLS-1$
				}
				viewer.setInput(layerManager.getCustomLayerKeys());
			}

		});

		viewer.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(final SelectionChangedEvent event) {
				final ISelection selection = event.getSelection();
				if (!selection.isEmpty()) {
					final Object selected = ((StructuredSelection) selection)
							.getFirstElement();
					updateActionStates(selected);
					transparenz.setEnabled(true);
					transparenzLabel.setEnabled(true);
					transparenz.setSelection(layerManager.getAlpha(selected));
				}
			}

		});

		makeActions();
		hookContextMenu();
		hookDoubleClickAction();
		contributeToActionBars();

		getSite().getPage().addPartListener(this);
	}

	@Override
	public void setFocus() {
		viewer.getControl().setFocus();
	}

	private void makeActions() {
		moveUpAction = new MoveUpAction();
		moveDownAction = new MoveDownAction();
		moveTopAction = new MoveTopAction();
		moveBottomAction = new MoveBottomAction();
		updateActionStates(null);
	}

	private void hookContextMenu() {
		// TODO
	}

	private void hookDoubleClickAction() {
		viewer.addDoubleClickListener(new IDoubleClickListener() {

			@Override
			public void doubleClick(final DoubleClickEvent event) {
				// TODO
			}

		});
	}

	private void contributeToActionBars() {
		// TODO
		// final IMenuManager menuManager =
		// getViewSite().getActionBars().getMenuManager();
		// menuManager.add(editAction);
		// menuManager.add(new Separator(IWorkbenchActionConstants.VIEW_EXT));

		final IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();
		toolBarManager.add(moveUpAction);
		toolBarManager.add(moveDownAction);
		toolBarManager.add(moveTopAction);
		toolBarManager.add(moveBottomAction);
		toolBarManager.add(new Separator(IWorkbenchActionConstants.VIEW_EXT));
	}

	private void updateActionStates(final Object key) {
		if (key == null) {
			moveUpAction.setEnabled(false);
			moveTopAction.setEnabled(false);
			moveDownAction.setEnabled(false);
			moveBottomAction.setEnabled(false);
		} else {
			if (layerManager.canMove(key, ILayerManager.Direction.Up)) {
				moveUpAction.setEnabled(true);
				moveTopAction.setEnabled(true);
			} else {
				moveUpAction.setEnabled(false);
				moveTopAction.setEnabled(false);
			}
			if (layerManager.canMove(key, ILayerManager.Direction.Down)) {
				moveDownAction.setEnabled(true);
				moveBottomAction.setEnabled(true);
			} else {
				moveDownAction.setEnabled(false);
				moveBottomAction.setEnabled(false);
			}
		}
	}

	private void moveSelected(final ILayerManager.Direction direction) {
		final ISelection selection = viewer.getSelection();
		if (!selection.isEmpty()) {
			final Object selected = ((StructuredSelection) selection)
					.getFirstElement();
			layerManager.move(selected, direction);
			viewer.setInput(layerManager.getCustomLayerKeys());
			updateActionStates(selected);
		}
	}

	@Override
	public void dispose() {
		getSite().getPage().removePartListener(this);

		super.dispose();
	}

	@Override
	public void checkStateChanged(final CheckStateChangedEvent event) {
		if (layerManager != null) {
			layerManager.setVisble(event.getElement(), event.getChecked());
		}

	}

	@Override
	public void partActivated(final IWorkbenchPart part) {
		if (!part.equals(this)) {
			final ILayerManager adapter = (ILayerManager) part
					.getAdapter(ILayerManager.class);
			if (adapter == null) {
				viewer.setInput(null);
				viewer.getControl().setEnabled(false);
				transparenz.setEnabled(false);
				transparenzLabel.setEnabled(false);
				layerManager = null;
			} else if (adapter != layerManager) {
				layerManager = adapter;
				final List<Object> visibleLayer = new ArrayList<Object>();
				for (final Object key : layerManager.getCustomLayerKeys()) {
					if (layerManager.isVisble(key)) {
						visibleLayer.add(key);
					}
				}
				viewer.setInput(layerManager.getCustomLayerKeys());
				viewer.setCheckedElements(visibleLayer.toArray());
				viewer.getControl().setEnabled(true);
				if (!viewer.getSelection().isEmpty()) {
					transparenz.setEnabled(true);
					transparenzLabel.setEnabled(true);
				}
			}
		}
	}

	@Override
	public void partBroughtToTop(final IWorkbenchPart part) {
		// TODO Auto-generated method stub

	}

	@Override
	public void partClosed(final IWorkbenchPart part) {
		final ILayerManager adapter = (ILayerManager) part
				.getAdapter(ILayerManager.class);
		if (adapter == layerManager) {
			viewer.setInput(null);
			viewer.getControl().setEnabled(false);
			transparenz.setEnabled(false);
			transparenzLabel.setEnabled(false);
			layerManager = null;
		}
	}

	@Override
	public void partDeactivated(final IWorkbenchPart part) {
		//
	}

	@Override
	public void partOpened(final IWorkbenchPart part) {
		//
	}

}
