/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.netz.rdssymbole;

import com.bitctrl.lib.eclipse.log.PluginLogger;
import de.bsvrz.buv.plugin.netz.rdssymbole.RDSSymbolePlugin;
import de.bsvrz.buv.plugin.netz.rdssymbole.RdsMeldungVerortung;
import de.bsvrz.buv.plugin.netz.rdssymbole.internal.RahmenwerkService;
import de.bsvrz.sys.funclib.bitctrl.modell.Aspekt;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocation;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerkehr;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsTMCRichtung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.parameter.PdRdsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten.KdTmcLocationCode;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten.KdTmcPunkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcLinie;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdAeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdInneresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.InneresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

final class RdsConverter {
    public static final Aspekt ASP = PdRdsMeldung.Aspekte.RdsEmpfangen;
    private static RdsConverter instance;
    private Map<Integer, List<AeusseresStrassenSegment>> tmcLocationCode2aess = new HashMap<Integer, List<AeusseresStrassenSegment>>();
    private final Map<Integer, TmcPunkt> tmcPunktMap = new HashMap<Integer, TmcPunkt>();
    private final PluginLogger pluginLogger;
    private final Logger logger = Logger.getLogger(RdsConverter.class.getName());

    private RdsConverter(ObjektFactory objektFactory, PluginLogger logger) {
        this.pluginLogger = logger;
        this.initCache(objektFactory);
    }

    static RdsConverter getInstance() {
        if (instance == null) {
            instance = new RdsConverter(RahmenwerkService.getService().getObjektFactory(), RDSSymbolePlugin.getDefault().getLogger());
        }
        return instance;
    }

    static RdsConverter getInstance(ObjektFactory objektFactory, PluginLogger pluginLogger) {
        if (instance == null) {
            instance = new RdsConverter(objektFactory, pluginLogger);
        }
        return instance;
    }

    private void initCache(ObjektFactory objektFactory) {
        this.tmcLocationCode2aess = new HashMap<Integer, List<AeusseresStrassenSegment>>();
        List ass = objektFactory.bestimmeModellobjekte(new String[]{"typ.\u00e4u\u00dferesStra\u00dfenSegment"});
        for (SystemObjekt so : ass) {
            AeusseresStrassenSegment segment = (AeusseresStrassenSegment)so;
            this.cacheLocationCode(segment);
        }
    }

    private void cacheLocationCode(AeusseresStrassenSegment aess) {
        KdTmcLocationCode.Daten locationCodeDaten;
        AttTmcLocationCode locationCode;
        TmcPunkt tmcPunkt;
        KdAeusseresStrassenSegment.Daten assKd = (KdAeusseresStrassenSegment.Daten)aess.getKdAeusseresStrassenSegment().getDatum();
        if (assKd != null && assKd.getTmcPrimaerOrt() != null && (tmcPunkt = assKd.getTmcPrimaerOrt()).getKdTmcLocationCode() != null && tmcPunkt.getKdTmcLocationCode().getDatum() != null && (locationCode = (locationCodeDaten = (KdTmcLocationCode.Daten)tmcPunkt.getKdTmcLocationCode().getDatum()).getTmcLocationCode()) != null) {
            this.tmcPunktMap.put((Integer)locationCode.getValue(), tmcPunkt);
            List<AeusseresStrassenSegment> aessSet = this.tmcLocationCode2aess.get(locationCode.getValue());
            if (aessSet == null) {
                aessSet = new ArrayList<AeusseresStrassenSegment>();
                this.tmcLocationCode2aess.put((Integer)locationCode.getValue(), aessSet);
            }
            aessSet.add(aess);
        }
    }

    private StartSegmente findeASS(Feld<AtlRdsLocation> rdsLocation, int startindex, AttTmcRichtung attTmcRichtung, RdsMeldung meldung) {
        ArrayList<AeusseresStrassenSegment> startAss = new ArrayList<AeusseresStrassenSegment>();
        int index = 0;
        if (startindex > rdsLocation.size() - 2) {
            return null;
        }
        List<AeusseresStrassenSegment> assSet = null;
        AtlRdsLocation loc = null;
        index = startindex + 1;
        while (index < rdsLocation.size()) {
            loc = (AtlRdsLocation)rdsLocation.get(index);
            assSet = this.tmcLocationCode2aess.get(loc.getLocationCode().intValue());
            if (assSet != null && assSet.size() != 0) {
                for (AeusseresStrassenSegment ass : assSet) {
                    if (!this.isAssNachKnoten(ass, attTmcRichtung, loc)) continue;
                    startAss.add(ass);
                }
                if (startAss.size() > 0) break;
            }
            ++index;
        }
        if (startAss.size() == 0) {
            return null;
        }
        return new StartSegmente(index, startAss);
    }

    public RdsMeldungVerortung verorte(RdsMeldung meldung) {
        PdRdsMeldung pdRdsMeldung = meldung.getPdRdsMeldung();
        PdRdsMeldung.Daten datum = (PdRdsMeldung.Daten)pdRdsMeldung.getDatum(ASP);
        if (!datum.dContainsDaten()) {
            this.logError("Die RDS-Meldung " + meldung.getPid() + " besitzt keine Daten unter dem Aspekt '" + String.valueOf(ASP) + "'");
            return null;
        }
        AtlRdsVerkehr verkehrsInformationen = datum.getVersion().getVerkehrsInformationen();
        Feld rdsLocation = verkehrsInformationen.getLocationDaten().getRDSLocation();
        if (rdsLocation.size() == 0) {
            this.logError("Die RDS-Meldung " + meldung.getPid() + " kann nicht verortet werden, da sie keine Lokationen besitzt");
            return null;
        }
        AttRdsTMCRichtung tmcRichtung = verkehrsInformationen.getLocationDaten().getTMCRichtung();
        AttTmcRichtung attTmcRichtung = tmcRichtung == AttRdsTMCRichtung.ZUSTAND_0_POSITIV ? AttTmcRichtung.ZUSTAND_1N_NEGATIV : AttTmcRichtung.ZUSTAND_1_POSITIV;
        Collections.reverse(rdsLocation);
        if (rdsLocation.size() == 1) {
            return this.verortePunktLokation((AtlRdsLocation)rdsLocation.get(0), attTmcRichtung, meldung);
        }
        return this.verorteMehrereLokationen((Feld<AtlRdsLocation>)rdsLocation, attTmcRichtung, meldung);
    }

    private RdsMeldungVerortung verorteMehrereLokationen(Feld<AtlRdsLocation> rdsLocation, AttTmcRichtung attTmcRichtung, RdsMeldung meldung) {
        StartSegmente startSegmente = this.findeASS(rdsLocation, 0, attTmcRichtung, meldung);
        if (startSegmente == null || startSegmente.getAss() == null || startSegmente.getAss().size() == 0) {
            this.logError("Die RDS-Meldung '" + meldung.getPid() + "' kann nicht verortet werden: Es konnte kein Startsegment bestimmt werden " + this.meldungLogInfo(meldung, rdsLocation, attTmcRichtung));
            return null;
        }
        List<StrassenSegment> segmente = this.verorteWeiter(startSegmente, rdsLocation, attTmcRichtung, meldung);
        return this.erzeugeVerortung(segmente, meldung);
    }

    private AeusseresStrassenSegment findeZufuehrendesAss(AtlRdsLocation rdsLocation, AttTmcRichtung attTmcRichtung, RdsMeldung meldung) {
        List<AeusseresStrassenSegment> assSet = null;
        assSet = this.tmcLocationCode2aess.get(rdsLocation.getLocationCode().intValue());
        if (assSet == null || assSet.size() == 0) {
            this.logError("Die RDS-Meldung " + meldung.getPid() + " konnte nicht verortet werden (die Lokation der Meldung ist in der VRZ nicht bekannt)");
            return null;
        }
        for (AeusseresStrassenSegment ass : assSet) {
            if (!this.isAssNachKnoten(ass, attTmcRichtung, rdsLocation)) continue;
            return ass;
        }
        return assSet.get(0);
    }

    private RdsMeldungVerortung verortePunktLokation(AtlRdsLocation rdsLocation, AttTmcRichtung attTmcRichtung, RdsMeldung meldung) {
        AeusseresStrassenSegment segment = this.findeZufuehrendesAss(rdsLocation, attTmcRichtung, meldung);
        if (segment != null) {
            return this.erzeugeVerortungPunkt(segment, meldung);
        }
        return null;
    }

    private List<StrassenSegment> verorteWeiter(StartSegmente startSegmente, Feld<AtlRdsLocation> rdsLocation, AttTmcRichtung attTmcRichtung, RdsMeldung meldung) {
        if (startSegmente == null) {
            return null;
        }
        ArrayList<RdsRoute> routen = new ArrayList<RdsRoute>();
        block0: for (AeusseresStrassenSegment ass : startSegmente.getAss()) {
            RdsRoute rdsroute = new RdsRoute();
            rdsroute.addSegment((StrassenSegment)ass);
            routen.add(rdsroute);
            AeusseresStrassenSegment startAss = ass;
            int i = startSegmente.getLocationIndex() + 1;
            while (i < rdsLocation.size()) {
                AtlRdsLocation loc = (AtlRdsLocation)rdsLocation.get(i);
                if (startAss == null) continue block0;
                List<StrassenSegment> route = this.findeSegmente(startAss, loc);
                if (route == null) {
                    rdsroute.setLetzteLokationUnbekannt(loc);
                } else {
                    rdsroute.setLetzteLokationUnbekannt(null);
                    if (route.size() > 0) {
                        rdsroute.addSegmente(route);
                        StrassenSegment strassenSegment = route.get(route.size() - 1);
                        if (!(strassenSegment instanceof AeusseresStrassenSegment)) continue block0;
                        startAss = (AeusseresStrassenSegment)strassenSegment;
                    }
                }
                ++i;
            }
        }
        Collections.sort(routen, new Comparator<RdsRoute>(){

            @Override
            public int compare(RdsRoute o1, RdsRoute o2) {
                return new Integer(o2.getSegmente().size()).compareTo(new Integer(o1.getSegmente().size()));
            }
        });
        RdsRoute ergebnis = (RdsRoute)routen.get(0);
        if (ergebnis.getLetzteLokationUnbekannt() != null) {
            AeusseresStrassenSegment lastass = null;
            int i = ergebnis.getSegmente().size() - 1;
            while (i >= 0) {
                StrassenSegment s = ergebnis.getSegmente().get(i);
                if (s instanceof AeusseresStrassenSegment) {
                    lastass = (AeusseresStrassenSegment)s;
                    break;
                }
                ++i;
            }
            if (lastass != null) {
                KdAeusseresStrassenSegment.Daten assKd = (KdAeusseresStrassenSegment.Daten)lastass.getKdAeusseresStrassenSegment().getDatum();
                this.logWarning("Die RDS-Meldung " + meldung.getPid() + " konnte nicht vollst\u00e4ndig verortet werden (es existiert kein Weg in " + String.valueOf(attTmcRichtung) + "er TMC-Richtung von Lokation " + String.valueOf(((KdTmcLocationCode.Daten)assKd.getTmcPrimaerOrt().getKdTmcLocationCode().getDatum()).getTmcLocationCode()) + " nach Lokation " + String.valueOf(ergebnis.getLetzteLokationUnbekannt().getLocationCode()) + " auf der Linienlokation " + ergebnis.getLetzteLokationUnbekannt().getLocationCodeLinienReferenz().intValue() + " am Ende der Lokationenliste)");
            }
        }
        return ergebnis.getSegmente();
    }

    private RdsMeldungVerortung erzeugeVerortung(List<StrassenSegment> segmentliste, RdsMeldung meldung) {
        if (segmentliste == null || segmentliste.size() == 0) {
            return null;
        }
        if (segmentliste.size() > 1 && segmentliste.get(0) instanceof InneresStrassenSegment) {
            segmentliste.remove(0);
        }
        boolean startoffset = false;
        int endOffset = ((KdStrassenSegment.Daten)segmentliste.get(segmentliste.size() - 1).getKdStrassenSegment().getDatum()).getLaenge().intValue();
        return new RdsMeldungVerortung(segmentliste, 0, endOffset);
    }

    private List<StrassenSegment> findeSegmente(AeusseresStrassenSegment startAss, AtlRdsLocation loc) {
        ArrayList<StrassenSegment> route = new ArrayList<StrassenSegment>();
        KdAeusseresStrassenSegment.Daten assKd = (KdAeusseresStrassenSegment.Daten)startAss.getKdAeusseresStrassenSegment().getDatum();
        StrassenKnoten knoten = assKd.getNachKnoten();
        if (this.isAssNachKnoten(startAss, assKd.getTmcRichtung(), loc)) {
            return route;
        }
        for (InneresStrassenSegment segment : knoten.getInnereStrassenSegmente()) {
            AeusseresStrassenSegment nachStrassenSegment;
            KdInneresStrassenSegment.Daten kdIss = (KdInneresStrassenSegment.Daten)segment.getKdInneresStrassenSegment().getDatum();
            if (kdIss.getVonStrassenSegment() == null || kdIss.getVonStrassenSegment() != startAss || (nachStrassenSegment = kdIss.getNachStrassenSegment()) == null || !this.isAssNachKnoten(nachStrassenSegment, assKd.getTmcRichtung(), loc)) continue;
            route.add((StrassenSegment)segment);
            route.add((StrassenSegment)nachStrassenSegment);
            return route;
        }
        return null;
    }

    private boolean isAssNachKnoten(AeusseresStrassenSegment ass, AttTmcRichtung tmcRichtung, AtlRdsLocation loc) {
        KdAeusseresStrassenSegment.Daten assKd = (KdAeusseresStrassenSegment.Daten)ass.getKdAeusseresStrassenSegment().getDatum();
        if (assKd.getTmcRichtung() == tmcRichtung) {
            TmcPunkt tmcPunkt = assKd.getTmcPrimaerOrt();
            KdTmcLocationCode.Daten datum = (KdTmcLocationCode.Daten)tmcPunkt.getKdTmcLocationCode().getDatum();
            if (datum.getTmcLocationCode().intValue() != loc.getLocationCode().intValue()) {
                return false;
            }
            TmcLinie istTeilvonTmcLinie = ((KdTmcPunkt.Daten)tmcPunkt.getKdTmcPunkt().getDatum()).getIstTeilvonTmcLinie();
            AttTmcLocationCode tmcLocationCode = ((KdTmcLocationCode.Daten)istTeilvonTmcLinie.getKdTmcLocationCode().getDatum()).getTmcLocationCode();
            if (tmcLocationCode.intValue() != loc.getLocationCodeLinienReferenz().intValue()) {
                this.logError("Die Linienlokation des TmcPrim\u00e4rortes des ASS (" + tmcLocationCode.intValue() + ", " + String.valueOf(tmcPunkt) + ") stimmt nicht mit der Linienlokation der Meldung (" + loc.getLocationCodeLinienReferenz().intValue() + ") \u00fcberein.");
                return false;
            }
            return true;
        }
        return false;
    }

    private RdsMeldungVerortung erzeugeVerortungPunkt(AeusseresStrassenSegment ass, RdsMeldung meldung) {
        AeusseresStrassenSegment segment = null;
        int startoffset = 0;
        KdAeusseresStrassenSegment.Daten assKd = (KdAeusseresStrassenSegment.Daten)ass.getKdAeusseresStrassenSegment().getDatum();
        StrassenKnoten nachKnoten = assKd.getNachKnoten();
        if (nachKnoten == null) {
            return null;
        }
        InneresStrassenSegment weiterfuehrendesIss = null;
        for (InneresStrassenSegment iss : nachKnoten.getInnereStrassenSegmente()) {
            int isslaenge;
            AeusseresStrassenSegment vonStrassenSegment = ((KdInneresStrassenSegment.Daten)iss.getKdInneresStrassenSegment().getDatum()).getVonStrassenSegment();
            if (vonStrassenSegment != ass) continue;
            if (((KdInneresStrassenSegment.Daten)iss.getKdInneresStrassenSegment().getDatum()).getNachStrassenSegment() != null && (weiterfuehrendesIss == null || ((KdStrassenSegment.Daten)weiterfuehrendesIss.getKdStrassenSegment().getDatum()).getLaenge().intValue() > ((KdStrassenSegment.Daten)iss.getKdStrassenSegment().getDatum()).getLaenge().intValue())) {
                weiterfuehrendesIss = iss;
            }
            if ((segment = weiterfuehrendesIss) == null || (isslaenge = ((KdStrassenSegment.Daten)segment.getKdStrassenSegment().getDatum()).getLaenge().intValue()) <= 0) continue;
            startoffset = isslaenge / 2;
        }
        if (segment == null) {
            segment = ass;
            startoffset = ((KdStrassenSegment.Daten)ass.getKdStrassenSegment().getDatum()).getLaenge().intValue();
        }
        ArrayList<StrassenSegment> segmente = new ArrayList<StrassenSegment>();
        segmente.add((StrassenSegment)segment);
        return new RdsMeldungVerortung(segmente, startoffset, startoffset);
    }

    private void logWarning(String msg) {
        if (this.pluginLogger != null) {
            this.pluginLogger.error(msg);
        } else {
            this.logger.severe(msg);
        }
    }

    private void logError(String msg) {
        if (this.pluginLogger != null) {
            this.pluginLogger.error(msg);
        } else {
            this.logger.severe(msg);
        }
    }

    private String meldungLogInfo(RdsMeldung meldung, Feld<AtlRdsLocation> rdsLocationen, AttTmcRichtung attTmcRichtung) {
        StringBuffer text = new StringBuffer();
        AttRdsTMCRichtung tmcRichtung = attTmcRichtung == AttTmcRichtung.ZUSTAND_1_POSITIV ? AttRdsTMCRichtung.ZUSTAND_1_NEGATIV : AttRdsTMCRichtung.ZUSTAND_0_POSITIV;
        text.append("(TMC-Richtung der Meldung: " + String.valueOf(tmcRichtung) + ", ");
        text.append("Lokationen: ");
        int i = 0;
        while (i < rdsLocationen.size()) {
            if (i > 0) {
                text.append(", ");
            }
            text.append(((AtlRdsLocation)rdsLocationen.get(i)).getLocationCode().getValue());
            ++i;
        }
        text.append(")");
        return text.toString();
    }

    private class RdsRoute {
        private final List<StrassenSegment> segmente = new ArrayList<StrassenSegment>();
        private AtlRdsLocation letzteLokationUnbekannt;

        public List<StrassenSegment> getSegmente() {
            return this.segmente;
        }

        public AtlRdsLocation getLetzteLokationUnbekannt() {
            return this.letzteLokationUnbekannt;
        }

        public void setLetzteLokationUnbekannt(AtlRdsLocation letzteLokationUnbekannt) {
            this.letzteLokationUnbekannt = letzteLokationUnbekannt;
        }

        public void addSegmente(List<StrassenSegment> neuesegmente) {
            this.segmente.addAll(neuesegmente);
        }

        public void addSegment(StrassenSegment segment) {
            this.segmente.add(segment);
        }
    }

    private class StartSegmente {
        private final int locationIndex;
        private final List<AeusseresStrassenSegment> ass;

        protected int getLocationIndex() {
            return this.locationIndex;
        }

        protected List<AeusseresStrassenSegment> getAss() {
            return this.ass;
        }

        public StartSegmente(int locationIndex, List<AeusseresStrassenSegment> ass) {
            this.locationIndex = locationIndex;
            this.ass = ass;
        }
    }
}

