/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.netz.rdssymbole;

import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.util.IDavZeitStempelManager;
import de.bsvrz.buv.plugin.dobj.util.Projektion;
import de.bsvrz.buv.plugin.netz.rdssymbole.RdsConverter;
import de.bsvrz.buv.plugin.netz.rdssymbole.RdsMeldungEditPart;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateListener;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.parameter.PdRdsMeldung;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.ui.PlatformUI;

abstract class RdsMeldungEmpfaenger
implements DatensatzUpdateListener {
    protected final RdsMeldungEditPart<?> editPart;
    protected PointList streckenabschnitt;

    RdsMeldungEmpfaenger(RdsMeldungEditPart<?> editPart) {
        this.editPart = editPart;
    }

    protected final RdsMeldung getRdsMeldung() {
        return (RdsMeldung)((BitCtrlDoModel)this.editPart.getModel()).getSystemObjekt();
    }

    protected final Projektion getProjektion() {
        return this.editPart.getProjektion();
    }

    final void anmelden() {
        this.getRdsMeldung().getPdRdsMeldung().addUpdateListener(RdsConverter.ASP, (DatensatzUpdateListener)this);
    }

    final void abmelden() {
        this.getRdsMeldung().getPdRdsMeldung().removeUpdateListener(RdsConverter.ASP, (DatensatzUpdateListener)this);
    }

    public void datensatzAktualisiert(final DatensatzUpdateEvent event) {
        if (!this.editPart.isActive()) {
            return;
        }
        this.updateZeitstempelLetzterDatensatz(event);
        if (PlatformUI.getWorkbench().getDisplay() != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RdsMeldungEmpfaenger.this.handleDatensatzAktualisiert((PdRdsMeldung.Daten)event.getDatum());
                    RdsMeldungEmpfaenger.this.editPart.refreshLocation();
                }
            });
        }
    }

    protected void updateZeitstempelLetzterDatensatz(DatensatzUpdateEvent event) {
        IDavZeitStempelManager davZeitStempelManager = this.editPart.getDavZeitStempelManager();
        if (event.getDatum().dContainsDaten() && davZeitStempelManager != null) {
            davZeitStempelManager.setLetztenEmpfangenenZeitStempel(event.getDatum().dGetZeitstempel().getTime(), event.getObjekt().getSystemObject());
        }
    }

    private void handleDatensatzAktualisiert(PdRdsMeldung.Daten datum) {
        this.streckenabschnitt = datum.dContainsDaten() ? this.getStreckenabschnitt(datum) : new PointList();
    }

    protected abstract PointList getStreckenabschnitt(PdRdsMeldung.Daten var1);

    final PointList getStreckenabschnitt() {
        return this.streckenabschnitt;
    }
}

