/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.netz.rdssymbole;

import de.bsvrz.buv.plugin.netz.rdssymbole.RdsConverter;
import de.bsvrz.buv.plugin.netz.rdssymbole.RdsMeldungEditPart;
import de.bsvrz.buv.plugin.netz.rdssymbole.RdsMeldungEmpfaenger;
import de.bsvrz.buv.plugin.netz.rdssymbole.RdsMeldungSymbolFigure;
import de.bsvrz.buv.plugin.netz.rdssymbole.RdsMeldungVerortung;
import de.bsvrz.buv.plugin.netz.rdssymbole.util.RdsCode;
import de.bsvrz.buv.plugin.netz.rdssymbole.util.TabelleEinleser;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Polygon;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisDaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.parameter.PdRdsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.util.geolib.WGS84Util;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.ui.PlatformUI;

class RdsMeldungSymbolEmpfaenger
extends RdsMeldungEmpfaenger {
    private static final TabelleEinleser TABELLE = new TabelleEinleser();
    private final RdsMeldungSymbolFigure figure;

    RdsMeldungSymbolEmpfaenger(RdsMeldungEditPart<?> editPart) {
        super(editPart);
        this.figure = null;
    }

    RdsMeldungSymbolEmpfaenger(RdsMeldungEditPart<?> editPart, RdsMeldungSymbolFigure figure) {
        super(editPart);
        this.figure = figure;
    }

    public TabelleEinleser getTabelle() {
        return TABELLE;
    }

    @Override
    protected PointList getStreckenabschnitt(PdRdsMeldung.Daten datum) {
        RdsMeldungVerortung verortung = RdsConverter.getInstance().verorte(this.getRdsMeldung());
        if (verortung == null || verortung.getSegmentListe().isEmpty()) {
            return new PointList();
        }
        List<StrassenSegment> strassenSegmente = verortung.getSegmentListe();
        WGS84Polygon polygon = WGS84Util.ausschneiden((Linie)((Linie)strassenSegmente.get(0)), (double)verortung.getStartOffset(), (double)-1.0);
        if (polygon.getKoordinaten().size() <= 1) {
            return new PointList();
        }
        WGS84Punkt wgs84Punkt = (WGS84Punkt)polygon.getKoordinaten().get(0);
        PrecisionPoint point = new PrecisionPoint(wgs84Punkt.getLaenge(), wgs84Punkt.getBreite());
        point = this.getProjektion().umrechnenWeltNachModel((Point)point);
        WGS84Punkt nextWgs84Punkt = (WGS84Punkt)polygon.getKoordinaten().get(1);
        PrecisionPoint nextPoint = new PrecisionPoint(nextWgs84Punkt.getLaenge(), nextWgs84Punkt.getBreite());
        nextPoint = this.getProjektion().umrechnenWeltNachModel((Point)new PrecisionPoint(nextWgs84Punkt.getLaenge(), nextWgs84Punkt.getBreite()));
        PointList pointList = new PointList();
        pointList.addPoint((Point)point);
        pointList.addPoint((Point)nextPoint);
        return pointList;
    }

    @Override
    public void datensatzAktualisiert(final DatensatzUpdateEvent event) {
        if (!this.editPart.isActive()) {
            return;
        }
        this.updateZeitstempelLetzterDatensatz(event);
        if (PlatformUI.getWorkbench().getDisplay() != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RdsMeldungSymbolEmpfaenger.this.handleDatensatzAktualisiert((PdRdsMeldung.Daten)event.getDatum());
                    RdsMeldungSymbolEmpfaenger.this.editPart.refreshLocation();
                }
            });
        }
    }

    private void handleDatensatzAktualisiert(PdRdsMeldung.Daten datum) {
        if (datum.dContainsDaten()) {
            this.streckenabschnitt = this.getStreckenabschnitt(datum);
            RdsCode priosymb = RdsCode.DEFAULT;
            if (datum.getVersion().getVerkehrsInformationen().getEreignis().getEreignisDaten().size() > 0) {
                int lauf = 0;
                while (lauf < datum.getVersion().getVerkehrsInformationen().getEreignis().getEreignisDaten().size()) {
                    int code = ((AtlRdsEreignisDaten)datum.getVersion().getVerkehrsInformationen().getEreignis().getEreignisDaten().get(lauf)).getEreignisCode().intValue();
                    RdsCode symb = code != 0 ? this.getTabelle().getZuordnung().get(code) : RdsCode.RDSMELDUNG;
                    if (symb.compareTo(priosymb) < 0) {
                        priosymb = symb;
                    }
                    ++lauf;
                }
            }
            this.figure.setImage(this.getTabelle().getImageByRdsCode(priosymb));
        } else {
            this.streckenabschnitt = new PointList();
        }
    }
}

