/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.netz.rdssymbole;

import de.bsvrz.buv.plugin.netz.rdssymbole.RdsMeldungEditPart;
import de.bsvrz.buv.plugin.netz.rdssymbole.RdsMeldungSymbolEmpfaenger;
import de.bsvrz.buv.plugin.netz.rdssymbole.RdsMeldungSymbolMitLaengeFigure;
import de.bsvrz.buv.plugin.netz.rdssymbole.util.RdsCode;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisDaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisQuantitaet;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.parameter.PdRdsMeldung;
import de.bsvrz.sys.funclib.debug.Debug;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.ui.PlatformUI;

class RdsMeldungSymbolMitLaengeEmpfaenger
extends RdsMeldungSymbolEmpfaenger {
    private final RdsMeldungSymbolMitLaengeFigure figure;

    RdsMeldungSymbolMitLaengeEmpfaenger(RdsMeldungEditPart<?> editPart, RdsMeldungSymbolMitLaengeFigure figure) {
        super(editPart);
        this.figure = figure;
    }

    @Override
    public final void datensatzAktualisiert(final DatensatzUpdateEvent event) {
        if (!this.editPart.isActive()) {
            return;
        }
        this.updateZeitstempelLetzterDatensatz(event);
        if (PlatformUI.getWorkbench().getDisplay() != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RdsMeldungSymbolMitLaengeEmpfaenger.this.handleDatensatzAktualisiert((PdRdsMeldung.Daten)event.getDatum());
                    RdsMeldungSymbolMitLaengeEmpfaenger.this.editPart.refreshLocation();
                }
            });
        }
    }

    private void handleDatensatzAktualisiert(PdRdsMeldung.Daten datum) {
        if (datum.dContainsDaten()) {
            this.streckenabschnitt = this.getStreckenabschnitt(datum);
            RdsCode priosymb = RdsCode.DEFAULT;
            Long laenge = null;
            if (datum.getVersion().getVerkehrsInformationen().getEreignis().getEreignisDaten().size() > 0) {
                int lauf = 0;
                while (lauf < datum.getVersion().getVerkehrsInformationen().getEreignis().getEreignisDaten().size()) {
                    int code = ((AtlRdsEreignisDaten)datum.getVersion().getVerkehrsInformationen().getEreignis().getEreignisDaten().get(lauf)).getEreignisCode().intValue();
                    RdsCode symb = code != 0 ? this.getTabelle().getZuordnung().get(code) : RdsCode.RDSMELDUNG;
                    if (symb.compareTo(priosymb) < 0 && (priosymb = symb) == RdsCode.STAU) {
                        for (AtlRdsEreignisQuantitaet quantitaet : ((AtlRdsEreignisDaten)datum.getVersion().getVerkehrsInformationen().getEreignis().getEreignisDaten().get(lauf)).getEreignisQuantitaet()) {
                            if (!"rdsQuantit\u00e4t.LEN".equals(quantitaet.getQuantitaetsKennung().getPid())) continue;
                            try {
                                laenge = Long.parseLong(quantitaet.getQuantitaetsWert());
                            }
                            catch (NumberFormatException e) {
                                Debug.getLogger().error("Falsches Zahlenformat!", (Throwable)e);
                            }
                        }
                        if (laenge == null) {
                            laenge = this.parseCodeStr(((AtlRdsEreignisDaten)datum.getVersion().getVerkehrsInformationen().getEreignis().getEreignisDaten().get(lauf)).getEreignisCode().toString());
                        }
                    }
                    ++lauf;
                }
            }
            this.figure.setImage(this.getTabelle().getImageByRdsCode(priosymb), laenge);
        } else {
            this.streckenabschnitt = new PointList();
        }
    }

    private Long parseCodeStr(String string) {
        Long result = null;
        if (string != null) {
            String[] parts = string.split(" ");
            int idx = 0;
            while (idx < parts.length) {
                if (parts[idx].equalsIgnoreCase("km") && idx > 0) {
                    try {
                        result = Long.parseLong(parts[idx - 1]);
                    }
                    catch (NumberFormatException e) {
                        Debug.getLogger().finest("", (Throwable)e);
                    }
                }
                ++idx;
            }
        }
        return result;
    }
}

