/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.netz.rdssymbole;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.netz.rdssymbole.RdsConverter;
import de.bsvrz.buv.plugin.netz.ui.DObjPopUp;
import de.bsvrz.buv.plugin.netz.ui.PopUpSizingHelper;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateListener;
import de.bsvrz.sys.funclib.bitctrl.modell.OnlineDatum;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichtenDaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenKlasse;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.parameter.PdRdsMeldung;
import java.util.Date;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class RdsMeldungsPopUp
extends DObjPopUp<RdsMeldung>
implements DatensatzUpdateListener {
    private final PdRdsMeldung rdsDatensatz = ((RdsMeldung)this.getSystemObjekt()).getPdRdsMeldung();
    private Text meldungsTextLabel;
    private Label aktualisierungsZeit;
    private Label ablaufZeit;
    private Label datenStatusLabel;

    RdsMeldungsPopUp(Shell shell, RdsMeldung meldung, DoModel doModel) {
        super(shell, (SystemObjekt)meldung, doModel);
    }

    protected Control createDialogArea(Composite parent) {
        String beschreibungText;
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(400, 2).grab(true, true).create());
        GridData gd = new GridData(768);
        this.meldungsTextLabel = new Text(composite, 66);
        this.meldungsTextLabel.setEditable(false);
        this.meldungsTextLabel.setLayoutData((Object)gd);
        String infoText = this.getInfoText();
        if (infoText != null) {
            this.infoTextLabel = new Label(composite, 0);
            this.infoTextLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
            this.infoTextLabel.setText("  Info: " + infoText);
        }
        if ((beschreibungText = this.getBeschreibungsText()) != null) {
            this.beschreibungsTextLabel = new Label(composite, 0);
            this.beschreibungsTextLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
            this.beschreibungsTextLabel.setText("  Beschreibung: " + beschreibungText);
        }
        if (this.doModel != null && this.doModel.getName() != null && this.doModel.getName().length() > 0) {
            this.doModelNameLabel = new Label(composite, 0);
            this.doModelNameLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
            this.doModelNameLabel.setText("  Model: " + this.doModel.getName());
        }
        this.aktualisierungsZeit = new Label(composite, 0);
        this.aktualisierungsZeit.setLayoutData((Object)gd);
        this.ablaufZeit = new Label(composite, 0);
        this.ablaufZeit.setLayoutData((Object)gd);
        this.datenStatusLabel = new Label(composite, 0);
        this.datenStatusLabel.setLayoutData((Object)gd);
        this.datenSatzListenerAnmelden();
        return composite;
    }

    public void datensatzAktualisiert(final DatensatzUpdateEvent event) {
        final PdRdsMeldung.Daten daten = (PdRdsMeldung.Daten)this.rdsDatensatz.getDatum();
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RdsMeldungsPopUp.this.getShell() == null || RdsMeldungsPopUp.this.getShell().isDisposed()) {
                    return;
                }
                RdsMeldungsPopUp.this.meldungsTextLabel.setText("<leerer Meldungstext>");
                RdsMeldungsPopUp.this.aktualisierungsZeit.setText("Aktualisierungszeit:  nicht ermittelbar");
                RdsMeldungsPopUp.this.ablaufZeit.setText("Ablaufzeit:  nicht ermittelbar");
                RdsMeldungsPopUp.this.setInfoText(event.getDatum().dGetDatenStatus().toString());
                if (event.getDatum().dGetDatenStatus() == OnlineDatum.Status.DATEN) {
                    long zeit = 0L;
                    if (daten.getVersion().getVerwaltungsInformationen().getAktualisierungsZeit() != null) {
                        zeit = daten.getVersion().getVerwaltungsInformationen().getAktualisierungsZeit().getTime();
                    }
                    if (zeit > 0L) {
                        RdsMeldungsPopUp.this.aktualisierungsZeit.setText("Aktualisierungszeit:  " + FORMAT_DATUM_ZEIT.format(new Date(zeit)));
                    }
                    zeit = 0L;
                    if (daten.getVersion().getVerwaltungsInformationen().getAblaufZeit() != null) {
                        zeit = daten.getVersion().getVerwaltungsInformationen().getAblaufZeit().getTime();
                    }
                    if (zeit > 0L) {
                        RdsMeldungsPopUp.this.ablaufZeit.setText("Ablaufzeit:  " + FORMAT_DATUM_ZEIT.format(new Date(zeit)));
                    }
                    String strNummerText = RdsMeldungsPopUp.this.getNachrichtenText(AttRdsNachrichtenKlasse.ZUSTAND_0_STRASSENNUMMER, daten);
                    String infoText = RdsMeldungsPopUp.this.getNachrichtenText(AttRdsNachrichtenKlasse.ZUSTAND_2_INHALT, daten);
                    String strSegmentText = RdsMeldungsPopUp.this.getNachrichtenText(AttRdsNachrichtenKlasse.ZUSTAND_1_SEGMENT, daten);
                    Object meldungsText = null;
                    if (strNummerText != null) {
                        meldungsText = strNummerText;
                    }
                    if (strSegmentText != null) {
                        meldungsText = meldungsText != null ? (String)meldungsText + " " + strSegmentText : strSegmentText;
                    }
                    Object meldungUndInfo = "";
                    if (meldungsText != null && ((String)meldungsText).length() > 0) {
                        meldungUndInfo = (String)meldungUndInfo + (String)meldungsText;
                    }
                    if (infoText != null && infoText.length() > 0) {
                        if (((String)meldungUndInfo).length() > 0) {
                            meldungUndInfo = (String)meldungUndInfo + "\n";
                        }
                        meldungUndInfo = (String)meldungUndInfo + infoText;
                    }
                    RdsMeldungsPopUp.this.meldungsTextLabel.setText(RdsMeldungsPopUp.part((String)meldungUndInfo, 70));
                } else {
                    RdsMeldungsPopUp.this.datenStatusLabel.setText(daten.dGetDatenStatus().toString());
                    RdsMeldungsPopUp.this.datenStatusLabel.setForeground(ColorConstants.red);
                }
                PopUpSizingHelper.resize((Control)RdsMeldungsPopUp.this.aktualisierungsZeit);
                PopUpSizingHelper.resize((Control)RdsMeldungsPopUp.this.ablaufZeit);
                PopUpSizingHelper.resize((Control)RdsMeldungsPopUp.this.datenStatusLabel);
                RdsMeldungsPopUp.this.getShell().pack();
                RdsMeldungsPopUp.this.constrainShellSize();
            }
        });
    }

    private static final String part(String longText, int maxLineLen) {
        Object result = "";
        if (longText != null) {
            String[] words = longText.split(" ");
            int i = 0;
            int currentLineLen = 0;
            while (i < words.length - 1) {
                result = (String)result + words[i];
                if ((currentLineLen += words[i].length()) > maxLineLen) {
                    result = (String)result + "\n";
                    currentLineLen = 0;
                } else {
                    result = (String)result + " ";
                }
                ++i;
            }
            result = (String)result + words[words.length - 1];
        }
        return result;
    }

    private String getNachrichtenText(AttRdsNachrichtenKlasse klasse, PdRdsMeldung.Daten datum) {
        String result = null;
        if (datum != null) {
            Feld nachrichtenDaten = datum.getVersion().getVerkehrsInformationen().getNachrichten().getNachrichtenDaten();
            for (AtlRdsNachrichtenDaten eintrag : nachrichtenDaten) {
                if (klasse != eintrag.getNachrichtenKlasse()) continue;
                result = eintrag.getNachrichtenText();
                break;
            }
        }
        return result;
    }

    private void datenSatzListenerAbmelden() {
        this.rdsDatensatz.removeUpdateListener(RdsConverter.ASP, (DatensatzUpdateListener)this);
    }

    private void datenSatzListenerAnmelden() {
        this.rdsDatensatz.addUpdateListener(RdsConverter.ASP, (DatensatzUpdateListener)this);
    }

    public boolean close() {
        this.datenSatzListenerAbmelden();
        return super.close();
    }
}

