/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.dobj.tmcSymbole;

import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungEmpfaenger;
import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungFigure;
import de.bsvrz.buv.dobj.tmcSymbole.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.decorator.LinienabstandMediator;
import de.bsvrz.buv.plugin.dobj.editparts.BitCtrlDoModelEditPart;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;
import de.bsvrz.buv.rw.bitctrl.CacheService;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.StreckenAbschnittCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcLocationCodeCache;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.geometry.PointList;

abstract class TmcMeldungEditPart<F extends TmcMeldungFigure>
extends BitCtrlDoModelEditPart<TmcVerkehrsMeldung, F> {
    private TmcMeldungEmpfaenger empfaenger;
    private static final CacheService CACHE_SERVICE = RahmenwerkService.getService().getCacheService();
    private static final TmcCache TMC_CACHE = CACHE_SERVICE.getTmcCache(CACHE_SERVICE.getDefaultNetzPid());
    private static final StreckenAbschnittCache ABSCHNITT_CACHE = CACHE_SERVICE.getStreckenAbschnittCache(CACHE_SERVICE.getDefaultNetzPid());
    private static final TmcLocationCodeCache LOCATION_CACHE = CACHE_SERVICE.getTmcLocationCodeCache();
    private PropertyChangeListener cacheListener;

    TmcMeldungEditPart() {
    }

    protected void geheOnline() {
        super.geheOnline();
        if (this.cachesOK() && this.getSystemObjekt() != null) {
            this.empfaenger = this.createTmcMeldungEmpfaenger();
            this.empfaenger.anmelden();
        }
    }

    protected abstract TmcMeldungEmpfaenger createTmcMeldungEmpfaenger();

    public void activate() {
        super.activate();
        this.cacheListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (TMC_CACHE.isInitialisiert()) {
                    TMC_CACHE.removePropertyChangeListener("state", (PropertyChangeListener)this);
                }
                if (ABSCHNITT_CACHE.isInitialisiert()) {
                    ABSCHNITT_CACHE.removePropertyChangeListener("state", (PropertyChangeListener)this);
                }
                if (LOCATION_CACHE.isInitialisiert()) {
                    LOCATION_CACHE.removePropertyChangeListener("state", (PropertyChangeListener)this);
                }
                if (TmcMeldungEditPart.this.cachesOK()) {
                    if (TmcMeldungEditPart.this.getSystemObjekt() != null) {
                        TmcMeldungEditPart.this.empfaenger = TmcMeldungEditPart.this.createTmcMeldungEmpfaenger();
                        TmcMeldungEditPart.this.empfaenger.anmelden();
                    }
                    TmcMeldungEditPart.this.refreshVisuals();
                }
            }
        };
        if (!TMC_CACHE.isInitialisiert()) {
            TMC_CACHE.addPropertyChangeListener("state", this.cacheListener);
        }
        if (!ABSCHNITT_CACHE.isInitialisiert()) {
            ABSCHNITT_CACHE.addPropertyChangeListener("state", this.cacheListener);
        }
        if (LOCATION_CACHE.isInitialisiert()) {
            LOCATION_CACHE.addPropertyChangeListener("state", this.cacheListener);
        }
    }

    public void deactivate() {
        if (TMC_CACHE != null && this.cacheListener != null) {
            TMC_CACHE.removePropertyChangeListener("state", this.cacheListener);
        }
        if (ABSCHNITT_CACHE != null && this.cacheListener != null) {
            ABSCHNITT_CACHE.removePropertyChangeListener("state", this.cacheListener);
        }
        if (LOCATION_CACHE != null && this.cacheListener != null) {
            LOCATION_CACHE.removePropertyChangeListener("state", this.cacheListener);
        }
        this.cacheListener = null;
        super.deactivate();
    }

    protected void geheOffline() {
        if (this.empfaenger != null) {
            this.empfaenger.abmelden();
            this.empfaenger = null;
        }
        super.geheOffline();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLocation();
        new LinienabstandMediator((DoModelEditPart)this).mediate();
    }

    final void refreshLocation() {
        if (this.empfaenger != null) {
            ((TmcMeldungFigure)this.getFigure()).setStreckenabschnitt(this.empfaenger.getStreckenabschnitt());
        } else {
            ((TmcMeldungFigure)this.getFigure()).setStreckenabschnitt(new PointList());
        }
    }

    public TmcCache getTmcCache() {
        return TMC_CACHE;
    }

    public boolean cachesOK() {
        return TMC_CACHE.isInitialisiert() && ABSCHNITT_CACHE.isInitialisiert() && LOCATION_CACHE.isInitialisiert();
    }

    public StreckenAbschnittCache getStreckenAbschnittCache() {
        return ABSCHNITT_CACHE;
    }

    public TmcLocationCodeCache getTmcLocationCodeCache() {
        return LOCATION_CACHE;
    }
}

