/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.dobj.tmcSymbole;

import com.bitctrl.lib.eclipse.log.PluginLogger;
import de.bsvrz.buv.dobj.tmcSymbole.TMCSymbolePlugin;
import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungEditPart;
import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungEmpfaenger;
import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungSymbolFigure;
import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungVerortung;
import de.bsvrz.buv.dobj.tmcSymbole.util.RdsCode;
import de.bsvrz.buv.dobj.tmcSymbole.util.TabelleEinleser;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Polygon;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcEreignisDaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.parameter.PdTmcVerkehrsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.util.geolib.WGS84Util;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.ui.PlatformUI;

class TmcMeldungSymbolEmpfaenger
extends TmcMeldungEmpfaenger {
    private static final TabelleEinleser TABELLE = new TabelleEinleser();
    private final TmcMeldungSymbolFigure figure;
    private final PluginLogger logger = TMCSymbolePlugin.getDefault().getLogger();

    TmcMeldungSymbolEmpfaenger(TmcMeldungEditPart<?> editPart) {
        super(editPart);
        this.figure = null;
    }

    TmcMeldungSymbolEmpfaenger(TmcMeldungEditPart<?> editPart, TmcMeldungSymbolFigure figure) {
        super(editPart);
        this.figure = figure;
    }

    public TabelleEinleser getTabelle() {
        return TABELLE;
    }

    @Override
    protected PointList getStreckenabschnitt(PdTmcVerkehrsMeldung.Daten datum) {
        WGS84Polygon polygon;
        TmcMeldungVerortung verortung = this.verorte(this.getTmcMeldung());
        if (verortung == null || verortung.getSegmentListe().isEmpty()) {
            return new PointList();
        }
        List<StrassenSegment> strassenSegmente = verortung.getSegmentListe();
        try {
            polygon = WGS84Util.abschneiden(strassenSegmente, (double)verortung.getStartOffset(), (double)verortung.getEndOffset());
        }
        catch (IllegalArgumentException ex) {
            this.logger.error("Das Polygon der Situation " + String.valueOf(datum.dGetDatensatz().getSystemObjekt()) + " konnte nicht aus den Stra\u00dfensegmente und dem Start- und Endoffset bestimmt werden.", (Throwable)ex);
            polygon = WGS84Util.verbinde(strassenSegmente);
        }
        if (polygon.getKoordinaten().size() <= 1) {
            return new PointList();
        }
        WGS84Punkt wgs84Punkt = (WGS84Punkt)polygon.getKoordinaten().get(0);
        PrecisionPoint point = new PrecisionPoint(wgs84Punkt.getLaenge(), wgs84Punkt.getBreite());
        point = this.getProjektion().umrechnenWeltNachModel((Point)point);
        WGS84Punkt nextWgs84Punkt = (WGS84Punkt)polygon.getKoordinaten().get(1);
        Point nextPoint = this.getProjektion().umrechnenWeltNachModel((Point)new PrecisionPoint(nextWgs84Punkt.getLaenge(), nextWgs84Punkt.getBreite()));
        PointList pointList = new PointList();
        pointList.addPoint((Point)point);
        pointList.addPoint(nextPoint);
        return pointList;
    }

    @Override
    public void datensatzAktualisiert(final DatensatzUpdateEvent event) {
        if (!this.editPart.isActive()) {
            return;
        }
        this.updateZeitstempelLetzterDatensatz(event);
        if (PlatformUI.getWorkbench().getDisplay() != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TmcMeldungSymbolEmpfaenger.this.handleDatensatzAktualisiert((PdTmcVerkehrsMeldung.Daten)event.getDatum());
                    TmcMeldungSymbolEmpfaenger.this.editPart.refreshLocation();
                }
            });
        }
    }

    private void handleDatensatzAktualisiert(PdTmcVerkehrsMeldung.Daten datum) {
        if (datum.dContainsDaten()) {
            this.streckenabschnitt = this.getStreckenabschnitt(datum);
            RdsCode priosymb = RdsCode.DEFAULT;
            if (datum.getTMCDaten().getEreignisInformationen().getEreignisDaten().size() > 0) {
                int lauf = 0;
                while (lauf < datum.getTMCDaten().getEreignisInformationen().getEreignisDaten().size()) {
                    int code = ((AtlTmcEreignisDaten)datum.getTMCDaten().getEreignisInformationen().getEreignisDaten().get(lauf)).getEreignisCode().intValue();
                    RdsCode symb = code != 0 ? this.getTabelle().getZuordnung().get(code) : RdsCode.RDSMELDUNG;
                    if (symb.compareTo(priosymb) < 0) {
                        priosymb = symb;
                    }
                    ++lauf;
                }
            }
            this.figure.setImage(this.getTabelle().getImageByRdsCode(priosymb));
        } else {
            this.streckenabschnitt = new PointList();
        }
    }
}

