/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.dobj.tmcSymbole;

import de.bsvrz.buv.dobj.tmcSymbole.TmcConverter;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.netz.ui.DObjPopUp;
import de.bsvrz.buv.plugin.netz.ui.PopUpSizingHelper;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateListener;
import de.bsvrz.sys.funclib.bitctrl.modell.OnlineDatum;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Zeitstempel;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.parameter.PdTmcVerkehrsMeldung;
import java.util.Date;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class TmcMeldungsPopUp
extends DObjPopUp<TmcVerkehrsMeldung>
implements DatensatzUpdateListener {
    private final PdTmcVerkehrsMeldung tmcDatensatz = ((TmcVerkehrsMeldung)this.getSystemObjekt()).getPdTmcVerkehrsMeldung();
    private Text meldungsTextLabel;
    private Label aktualisierungsZeit;
    private Label ablaufZeit;
    private Label datenStatusLabel;

    TmcMeldungsPopUp(Shell shell, TmcVerkehrsMeldung meldung, DoModel doModel) {
        super(shell, (SystemObjekt)meldung, doModel);
    }

    protected Control createDialogArea(Composite parent) {
        String beschreibungText;
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(400, 2).grab(true, true).create());
        GridData gd = new GridData(768);
        this.meldungsTextLabel = new Text(composite, 66);
        this.meldungsTextLabel.setEditable(false);
        this.meldungsTextLabel.setLayoutData((Object)gd);
        String infoText = this.getInfoText();
        if (infoText != null) {
            this.infoTextLabel = new Label(composite, 0);
            this.infoTextLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
            this.infoTextLabel.setText("  Info: " + infoText);
        }
        if ((beschreibungText = this.getBeschreibungsText()) != null) {
            this.beschreibungsTextLabel = new Label(composite, 0);
            this.beschreibungsTextLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
            this.beschreibungsTextLabel.setText("  Beschreibung: " + beschreibungText);
        }
        if (this.doModel != null && this.doModel.getName() != null && this.doModel.getName().length() > 0) {
            this.doModelNameLabel = new Label(composite, 0);
            this.doModelNameLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
            this.doModelNameLabel.setText("  Model: " + this.doModel.getName());
        }
        this.aktualisierungsZeit = new Label(composite, 0);
        this.aktualisierungsZeit.setLayoutData((Object)gd);
        this.ablaufZeit = new Label(composite, 0);
        this.ablaufZeit.setLayoutData((Object)gd);
        this.datenStatusLabel = new Label(composite, 0);
        this.datenStatusLabel.setLayoutData((Object)gd);
        this.datenSatzListenerAnmelden();
        return composite;
    }

    public void datensatzAktualisiert(final DatensatzUpdateEvent event) {
        final PdTmcVerkehrsMeldung.Daten daten = (PdTmcVerkehrsMeldung.Daten)event.getDatum();
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TmcMeldungsPopUp.this.getShell() == null || TmcMeldungsPopUp.this.getShell().isDisposed()) {
                    return;
                }
                TmcMeldungsPopUp.this.meldungsTextLabel.setText("<leerer Meldungstext>");
                TmcMeldungsPopUp.this.aktualisierungsZeit.setText("Aktualisierungszeit:  nicht ermittelbar");
                TmcMeldungsPopUp.this.ablaufZeit.setText("Ablaufzeit:  nicht ermittelbar");
                TmcMeldungsPopUp.this.setInfoText(event.getDatum().dGetDatenStatus().toString());
                if (event.getDatum().dGetDatenStatus() == OnlineDatum.Status.DATEN) {
                    long zeit = 0L;
                    if (daten.getTMCDaten().getVerwaltungsInformationen().getAktualisierungsZeit().size() > 0) {
                        zeit = ((Zeitstempel)daten.getTMCDaten().getVerwaltungsInformationen().getAktualisierungsZeit().get(0)).getTime();
                    }
                    if (zeit > 0L) {
                        TmcMeldungsPopUp.this.aktualisierungsZeit.setText("Aktualisierungszeit:  " + FORMAT_DATUM_ZEIT.format(new Date(zeit)));
                    }
                    zeit = 0L;
                    if (daten.getTMCDaten().getVerwaltungsInformationen().getEndeZeit().size() > 0) {
                        zeit = ((Zeitstempel)daten.getTMCDaten().getVerwaltungsInformationen().getEndeZeit().get(0)).getTime();
                    }
                    if (zeit > 0L) {
                        TmcMeldungsPopUp.this.ablaufZeit.setText("Ablaufzeit:  " + FORMAT_DATUM_ZEIT.format(new Date(zeit)));
                    }
                    String meldungsText = daten.getBeschreibung();
                    Object meldungUndInfo = "";
                    if (meldungsText != null && meldungsText.length() > 0) {
                        meldungUndInfo = (String)meldungUndInfo + meldungsText;
                    }
                    TmcMeldungsPopUp.this.meldungsTextLabel.setText(TmcMeldungsPopUp.part((String)meldungUndInfo, 70));
                } else {
                    TmcMeldungsPopUp.this.datenStatusLabel.setText(daten.dGetDatenStatus().toString());
                    TmcMeldungsPopUp.this.datenStatusLabel.setForeground(ColorConstants.red);
                }
                PopUpSizingHelper.resize((Control)TmcMeldungsPopUp.this.aktualisierungsZeit);
                PopUpSizingHelper.resize((Control)TmcMeldungsPopUp.this.ablaufZeit);
                PopUpSizingHelper.resize((Control)TmcMeldungsPopUp.this.datenStatusLabel);
                TmcMeldungsPopUp.this.getShell().pack();
                TmcMeldungsPopUp.this.constrainShellSize();
            }
        });
    }

    private static String part(String longText, int maxLineLen) {
        StringBuffer result = new StringBuffer();
        if (longText != null) {
            String[] words = longText.split(" ");
            int i = 0;
            int currentLineLen = 0;
            while (i < words.length - 1) {
                result.append(words[i]);
                if ((currentLineLen += words[i].length()) > maxLineLen) {
                    result.append('\n');
                    currentLineLen = 0;
                } else {
                    result.append(' ');
                }
                ++i;
            }
            result.append(words[words.length - 1]);
        }
        return result.toString();
    }

    private void datenSatzListenerAbmelden() {
        this.tmcDatensatz.removeUpdateListener(TmcConverter.ASP, (DatensatzUpdateListener)this);
    }

    private void datenSatzListenerAnmelden() {
        this.tmcDatensatz.addUpdateListener(TmcConverter.ASP, (DatensatzUpdateListener)this);
    }

    public boolean close() {
        this.datenSatzListenerAbmelden();
        return super.close();
    }
}

