/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.dobj.tmcSymbole;

import com.bitctrl.lib.eclipse.log.PluginLogger;
import de.bsvrz.buv.dobj.tmcSymbole.TMCSymbolePlugin;
import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungEditPart;
import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungVerortung;
import de.bsvrz.buv.dobj.tmcSymbole.internal.RahmenwerkService;
import de.bsvrz.buv.rw.bitctrl.CacheService;
import de.bsvrz.sys.funclib.bitctrl.modell.Aspekt;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.att.WerteBereich;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsTMCRichtung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten.KdTmcLocationCode;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcLokationsDaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.parameter.PdTmcVerkehrsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdAeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdInneresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.InneresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.StreckenAbschnitt;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.StreckenAbschnittCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcLocationCodeCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc.TmcLinieWrapper;
import de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc.TmcPunktWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

final class TmcConverter {
    public static final Aspekt ASP = PdTmcVerkehrsMeldung.Aspekte.TmcEmpfangen;
    private static TmcConverter instance;
    private Map<Integer, List<AeusseresStrassenSegment>> tmcLocationCode2aess = new HashMap<Integer, List<AeusseresStrassenSegment>>();
    private final Map<Integer, TmcPunkt> tmcPunktMap = new HashMap<Integer, TmcPunkt>();
    private final PluginLogger pluginLogger;
    private final Logger logger = Logger.getLogger(TmcConverter.class.getName());
    private final TmcMeldungEditPart<?> editpart;

    private TmcConverter(ObjektFactory objektFactory, PluginLogger logger, TmcMeldungEditPart<?> editPart) {
        this.pluginLogger = logger;
        this.initCache(objektFactory);
        this.editpart = editPart;
    }

    static TmcConverter getInstance(TmcMeldungEditPart<?> editPart) {
        if (instance == null) {
            instance = new TmcConverter(RahmenwerkService.getService().getObjektFactory(), TMCSymbolePlugin.getDefault().getLogger(), editPart);
        }
        return instance;
    }

    static TmcConverter getInstance(ObjektFactory objektFactory, PluginLogger pluginLogger) {
        if (instance == null) {
            instance = new TmcConverter(objektFactory, pluginLogger, null);
        }
        return instance;
    }

    private void initCache(ObjektFactory objektFactory) {
        this.tmcLocationCode2aess = new HashMap<Integer, List<AeusseresStrassenSegment>>();
        List ass = objektFactory.bestimmeModellobjekte(new String[]{"typ.\u00e4u\u00dferesStra\u00dfenSegment"});
        for (SystemObjekt so : ass) {
            AeusseresStrassenSegment segment = (AeusseresStrassenSegment)so;
            this.cacheLocationCode(segment);
        }
    }

    private void cacheLocationCode(AeusseresStrassenSegment aess) {
        KdTmcLocationCode.Daten locationCodeDaten;
        AttTmcLocationCode locationCode;
        TmcPunkt tmcPunkt;
        KdAeusseresStrassenSegment.Daten assKd = (KdAeusseresStrassenSegment.Daten)aess.getKdAeusseresStrassenSegment().getDatum();
        if (assKd != null && assKd.getTmcPrimaerOrt() != null && (tmcPunkt = assKd.getTmcPrimaerOrt()).getKdTmcLocationCode() != null && tmcPunkt.getKdTmcLocationCode().getDatum() != null && (locationCode = (locationCodeDaten = (KdTmcLocationCode.Daten)tmcPunkt.getKdTmcLocationCode().getDatum()).getTmcLocationCode()) != null) {
            this.tmcPunktMap.put((Integer)locationCode.getValue(), tmcPunkt);
            List<AeusseresStrassenSegment> aessSet = this.tmcLocationCode2aess.get(locationCode.getValue());
            if (aessSet == null) {
                aessSet = new ArrayList<AeusseresStrassenSegment>();
                this.tmcLocationCode2aess.put((Integer)locationCode.getValue(), aessSet);
            }
            aessSet.add(aess);
        }
    }

    public TmcMeldungVerortung verorte(TmcVerkehrsMeldung meldung) {
        if (!this.editpart.cachesOK()) {
            return null;
        }
        PdTmcVerkehrsMeldung pdRdsMeldung = meldung.getPdTmcVerkehrsMeldung();
        PdTmcVerkehrsMeldung.Daten datum = (PdTmcVerkehrsMeldung.Daten)pdRdsMeldung.getDatum(ASP);
        if (!datum.dContainsDaten()) {
            this.logError("Die TMC-Meldung " + meldung.getPid() + " besitzt keine Daten unter dem Aspekt '" + String.valueOf(ASP) + "'");
            return null;
        }
        Feld lokationsDaten = datum.getTMCDaten().getVerortungsInformationen().getLokationsDaten();
        if (lokationsDaten.size() == 0) {
            this.logError("Die TMC-Meldung " + meldung.getPid() + " kann nicht verortet werden, da sie keine Lokationen besitzt");
            return null;
        }
        lokationsDaten.size();
        AtlTmcLokationsDaten atlTmcLokationsDaten = (AtlTmcLokationsDaten)lokationsDaten.get(0);
        AttTmcRichtung tmcRichtung = atlTmcLokationsDaten.getTMCRichtung();
        AttTmcRichtung attTmcRichtung = tmcRichtung == AttTmcRichtung.ZUSTAND_1_POSITIV ? AttTmcRichtung.ZUSTAND_1N_NEGATIV : AttTmcRichtung.ZUSTAND_1_POSITIV;
        AttTmcLocationCode primaerLokation = atlTmcLokationsDaten.getPrimaerLokation();
        AttTmcLocationCode sekundaerLokation = atlTmcLokationsDaten.getSekundaerLokation();
        if ((double)((Integer)sekundaerLokation.getValue()).intValue() == WerteBereich.getWerteBereich(AttTmcLocationCode.class).getMinimum()) {
            return this.verortePunktLokation(primaerLokation, attTmcRichtung, meldung);
        }
        return this.verorteMehrereLokationen(primaerLokation, sekundaerLokation, attTmcRichtung, meldung);
    }

    private StrassenKnoten getKnoten(AttTmcLocationCode lokation) {
        TmcLocationCodeCache tmcLocationCodeCache = this.editpart.getTmcLocationCodeCache();
        TmcPunktWrapper tmcPunktWrapper = tmcLocationCodeCache.getTmcPunktWrapper(lokation);
        if (tmcPunktWrapper == null) {
            return null;
        }
        TmcCache tmcCache = this.editpart.getTmcCache();
        return tmcCache.getStrassenKnoten(tmcPunktWrapper.getTmcPunkt());
    }

    private Strasse getStrasse(AttTmcLocationCode lokation) {
        CacheService cs = RahmenwerkService.getService().getCacheService();
        TmcLocationCodeCache tmcLocationCodeCache = this.editpart.getTmcLocationCodeCache();
        TmcPunktWrapper tmcPunktWrapper = tmcLocationCodeCache.getTmcPunktWrapper(lokation);
        if (tmcPunktWrapper == null) {
            return null;
        }
        TmcCache tmcCache = cs.getTmcCache(cs.getDefaultNetzPid());
        TmcLinieWrapper tmcLinieWrapper = tmcLocationCodeCache.getTmcLinieWrapper(tmcPunktWrapper.getIstTeilvonTmcLinie(), AttRdsTMCRichtung.ZUSTAND_0_POSITIV);
        return tmcCache.getStrasse(tmcLinieWrapper.getTmcLinie());
    }

    private TmcMeldungVerortung verorteMehrereLokationen(AttTmcLocationCode primaerLokation, AttTmcLocationCode sekundaerLokation, AttTmcRichtung attTmcRichtung, TmcVerkehrsMeldung meldung) {
        StreckenAbschnittCache streckenAbschnittCache = this.editpart.getStreckenAbschnittCache();
        StrassenKnoten startKnoten = this.getKnoten(primaerLokation);
        StrassenKnoten endKnoten = this.getKnoten(sekundaerLokation);
        Strasse strasse = this.getStrasse(primaerLokation);
        if (strasse == null) {
            return null;
        }
        if (startKnoten == null && endKnoten == null) {
            return null;
        }
        if (startKnoten != null && endKnoten == null) {
            return this.verortePunktLokation(primaerLokation, attTmcRichtung, meldung);
        }
        if (endKnoten != null && startKnoten == null) {
            return this.verortePunktLokation(sekundaerLokation, attTmcRichtung, meldung);
        }
        List streckenAbschnitte = streckenAbschnittCache.getStreckenAbschnitte(strasse, attTmcRichtung, endKnoten, startKnoten);
        if (streckenAbschnitte == null || streckenAbschnitte.size() == 0) {
            this.logError("Die TMC-Meldung '" + meldung.getPid() + "' kann nicht verortet werden: Es konnten kein Streckenabschnitte bestimmt werden " + this.meldungLogInfo(meldung, primaerLokation, sekundaerLokation, attTmcRichtung));
            return null;
        }
        StreckenAbschnitt a = (StreckenAbschnitt)streckenAbschnitte.get(0);
        List strassenSegmente = a.getStrassenSegmente();
        if (strassenSegmente == null || strassenSegmente.size() == 0) {
            this.logError("Die TMC-Meldung '" + meldung.getPid() + "' kann nicht verortet werden: Es konnten keine Segmente bestimmt werden " + this.meldungLogInfo(meldung, primaerLokation, sekundaerLokation, attTmcRichtung));
            return null;
        }
        return this.erzeugeVerortung(strassenSegmente, meldung);
    }

    private AeusseresStrassenSegment findeZufuehrendesAss(AttTmcLocationCode rdsLocation, AttTmcRichtung attTmcRichtung, TmcVerkehrsMeldung meldung) {
        List<AeusseresStrassenSegment> assSet = null;
        assSet = this.tmcLocationCode2aess.get(rdsLocation.intValue());
        if (assSet == null || assSet.size() == 0) {
            this.logError("Die TMC-Meldung " + meldung.getPid() + " konnte nicht verortet werden (die Lokation der Meldung ist in der VRZ nicht bekannt)");
            return null;
        }
        for (AeusseresStrassenSegment ass : assSet) {
            if (!this.isAssNachKnoten(ass, attTmcRichtung, rdsLocation)) continue;
            return ass;
        }
        return assSet.get(0);
    }

    private TmcMeldungVerortung verortePunktLokation(AttTmcLocationCode rdsLocation, AttTmcRichtung attTmcRichtung, TmcVerkehrsMeldung meldung) {
        AeusseresStrassenSegment segment = this.findeZufuehrendesAss(rdsLocation, attTmcRichtung, meldung);
        if (segment != null) {
            return this.erzeugeVerortungPunkt(segment, meldung);
        }
        return null;
    }

    private TmcMeldungVerortung erzeugeVerortung(List<StrassenSegment> segmentliste, TmcVerkehrsMeldung meldung) {
        if (segmentliste == null || segmentliste.size() == 0) {
            return null;
        }
        if (segmentliste.size() > 1 && segmentliste.get(0) instanceof InneresStrassenSegment) {
            segmentliste.remove(0);
        }
        boolean startoffset = false;
        int endOffset = ((KdStrassenSegment.Daten)segmentliste.get(segmentliste.size() - 1).getKdStrassenSegment().getDatum()).getLaenge().intValue();
        return new TmcMeldungVerortung(segmentliste, 0, endOffset);
    }

    private boolean isAssNachKnoten(AeusseresStrassenSegment ass, AttTmcRichtung tmcRichtung, AttTmcLocationCode loc) {
        KdAeusseresStrassenSegment.Daten assKd = (KdAeusseresStrassenSegment.Daten)ass.getKdAeusseresStrassenSegment().getDatum();
        if (assKd.getTmcRichtung() == tmcRichtung) {
            TmcPunkt tmcPunkt = assKd.getTmcPrimaerOrt();
            KdTmcLocationCode.Daten datum = (KdTmcLocationCode.Daten)tmcPunkt.getKdTmcLocationCode().getDatum();
            return datum.getTmcLocationCode().intValue() == loc.intValue();
        }
        return false;
    }

    private TmcMeldungVerortung erzeugeVerortungPunkt(AeusseresStrassenSegment ass, TmcVerkehrsMeldung meldung) {
        AeusseresStrassenSegment segment = null;
        int startoffset = 0;
        KdAeusseresStrassenSegment.Daten assKd = (KdAeusseresStrassenSegment.Daten)ass.getKdAeusseresStrassenSegment().getDatum();
        StrassenKnoten nachKnoten = assKd.getNachKnoten();
        if (nachKnoten == null) {
            return null;
        }
        InneresStrassenSegment weiterfuehrendesIss = null;
        for (InneresStrassenSegment iss : nachKnoten.getInnereStrassenSegmente()) {
            int isslaenge;
            AeusseresStrassenSegment vonStrassenSegment = ((KdInneresStrassenSegment.Daten)iss.getKdInneresStrassenSegment().getDatum()).getVonStrassenSegment();
            if (vonStrassenSegment != ass) continue;
            if (((KdInneresStrassenSegment.Daten)iss.getKdInneresStrassenSegment().getDatum()).getNachStrassenSegment() != null && (weiterfuehrendesIss == null || ((KdStrassenSegment.Daten)weiterfuehrendesIss.getKdStrassenSegment().getDatum()).getLaenge().intValue() > ((KdStrassenSegment.Daten)iss.getKdStrassenSegment().getDatum()).getLaenge().intValue())) {
                weiterfuehrendesIss = iss;
            }
            if ((segment = weiterfuehrendesIss) == null || (isslaenge = ((KdStrassenSegment.Daten)segment.getKdStrassenSegment().getDatum()).getLaenge().intValue()) <= 0) continue;
            startoffset = isslaenge / 2;
        }
        if (segment == null) {
            segment = ass;
            startoffset = ((KdStrassenSegment.Daten)ass.getKdStrassenSegment().getDatum()).getLaenge().intValue();
        }
        ArrayList<StrassenSegment> segmente = new ArrayList<StrassenSegment>();
        segmente.add((StrassenSegment)segment);
        return new TmcMeldungVerortung(segmente, startoffset, startoffset);
    }

    private void logError(String msg) {
        if (this.pluginLogger != null) {
            this.pluginLogger.error(msg);
        } else {
            this.logger.severe(msg);
        }
    }

    private String meldungLogInfo(TmcVerkehrsMeldung meldung, AttTmcLocationCode prim, AttTmcLocationCode sek, AttTmcRichtung attTmcRichtung) {
        StringBuffer text = new StringBuffer();
        AttRdsTMCRichtung tmcRichtung = attTmcRichtung == AttTmcRichtung.ZUSTAND_1_POSITIV ? AttRdsTMCRichtung.ZUSTAND_1_NEGATIV : AttRdsTMCRichtung.ZUSTAND_0_POSITIV;
        text.append("(TMC-Richtung der Meldung: " + String.valueOf(tmcRichtung));
        text.append(", Prim\u00e4rlokation: " + prim.intValue());
        text.append(", Sekund\u00e4rlokation: " + sek.intValue());
        text.append(")");
        return text.toString();
    }
}

