/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.dobj.tmcSymbole;

import com.bitctrl.lib.eclipse.draw2d.FixedSizeFigure;
import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungSymbolFigure;
import de.bsvrz.buv.plugin.dobj.kollision.KollisionsManager;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

class TmcMeldungSymbolMitLaengeFigure
extends TmcMeldungSymbolFigure {
    private FixedSizeFigure symbol;
    private static final FontDescriptor STAULAENGE_FONT = FontDescriptor.createFrom((String)"Arial", (int)8, (int)0);
    private static final String STAULAENGE_UNBEKANNT = "----";
    private final Font staulaengeFont;
    private final Label staulaenge;
    private final Dimension dimMitLaenge;
    private final Dimension dimOhneLaenge;

    public TmcMeldungSymbolMitLaengeFigure(KollisionsManager kollisionsManager, ResourceManager resourceManager, Image image) {
        super(kollisionsManager, image);
        this.staulaengeFont = resourceManager.createFont(STAULAENGE_FONT);
        this.staulaenge = new Label(STAULAENGE_UNBEKANNT);
        this.staulaenge.setOpaque(true);
        this.staulaenge.setBackgroundColor(ColorConstants.tooltipBackground);
        this.staulaenge.setForegroundColor(ColorConstants.tooltipForeground);
        this.staulaenge.setFont(this.staulaengeFont);
        this.symbol = this.getSymbol();
        Dimension symbolSize = this.symbol.getDimension();
        int fontHeight = this.staulaengeFont.getFontData()[0].getHeight();
        Dimension staulaengeSize = new Dimension(symbolSize.width, fontHeight + 4);
        this.staulaenge.setLocation(new Point(0, symbolSize.height));
        this.staulaenge.setSize(staulaengeSize);
        this.dimMitLaenge = new Dimension(symbolSize.width, symbolSize.height + staulaengeSize.height);
        this.dimOhneLaenge = new Dimension(symbolSize.width, symbolSize.height);
        this.symbol.add((IFigure)this.staulaenge);
        this.symbol.setDimension(this.dimMitLaenge);
        this.updateFigure();
    }

    private void setStaulaenge(long staulaengeInKm) {
        if (staulaengeInKm > 0L) {
            this.staulaenge.setText(staulaengeInKm + " km");
        } else {
            this.staulaenge.setText(STAULAENGE_UNBEKANNT);
        }
    }

    protected void setImage(Image image, Long laenge) {
        Dimension imageSize = new Dimension(image);
        this.symbol = this.getSymbol();
        this.symbol.removeAll();
        ImageFigure imageFigure = new ImageFigure(image);
        imageFigure.setSize(imageSize);
        this.symbol.add((IFigure)imageFigure);
        if (laenge != null) {
            if (laenge > 0L) {
                this.setStaulaenge(laenge);
                this.symbol.add((IFigure)this.staulaenge);
                this.symbol.setDimension(this.dimMitLaenge);
            }
        } else {
            this.symbol.setDimension(this.dimOhneLaenge);
        }
        this.add((IFigure)this.symbol);
        this.updateBounds();
        this.updateFigure();
    }
}

