/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.dobj.tmcSymbole.util;

import de.bsvrz.buv.dobj.tmcSymbole.TMCSymbolePlugin;
import de.bsvrz.buv.dobj.tmcSymbole.util.NetzIcons;
import de.bsvrz.buv.dobj.tmcSymbole.util.RdsCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class TabelleEinleser {
    private final Map<Integer, RdsCode> zuordnung = new HashMap<Integer, RdsCode>(1400);

    public final Map<Integer, RdsCode> getZuordnung() {
        return this.zuordnung;
    }

    public TabelleEinleser() {
        try {
            InputStream inst = FileLocator.openStream((Bundle)TMCSymbolePlugin.getDefault().getBundle(), (IPath)new Path("res/Event_Codes_fuer_VRZ.xls"), (boolean)false);
            Workbook wb = Workbook.getWorkbook((InputStream)inst);
            Sheet blatt = wb.getSheet("Eventcode");
            int anzZeilen = blatt.getRows();
            int code = 0;
            int symbol = 0;
            int lauf = 1;
            while (lauf < anzZeilen) {
                code = Integer.parseInt(blatt.getCell(1, lauf).getContents());
                symbol = Integer.parseInt(blatt.getCell(2, lauf).getContents());
                this.zuordnung.put(code, RdsCode.getCode(symbol));
                ++lauf;
            }
        }
        catch (IOException e) {
            System.out.println("Tabelle mit Event-Codes nicht gefunden.");
            e.printStackTrace();
        }
        catch (BiffException e) {
            System.out.println("Probleme in Excel-Bibliothek.");
            e.printStackTrace();
        }
    }

    public Image getImageByRdsCode(RdsCode code) {
        switch (code) {
            case STAU: {
                return NetzIcons.Stau_Icon.getImage();
            }
            case SPERRUNG: {
                return NetzIcons.Sperrung_Icon.getImage();
            }
            case ACHTUNG: {
                return NetzIcons.Achtung_Icon.getImage();
            }
            case RDSMELDUNG: {
                return NetzIcons.RDSMeldung_Icon.getImage();
            }
            case AUFHEBUNG: {
                return NetzIcons.Aufhebung_Icon.getImage();
            }
        }
        return NetzIcons.RDSMeldung_Icon.getImage();
    }
}

