/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.dobj.tmcSymbole;

import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungEditPart;
import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungSymbolEmpfaenger;
import de.bsvrz.buv.dobj.tmcSymbole.TmcMeldungSymbolMitLaengeFigure;
import de.bsvrz.buv.dobj.tmcSymbole.util.RdsCode;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcEreignisDaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.parameter.PdTmcVerkehrsMeldung;
import de.bsvrz.sys.funclib.debug.Debug;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.ui.PlatformUI;

class TmcMeldungSymbolMitLaengeEmpfaenger
extends TmcMeldungSymbolEmpfaenger {
    private final TmcMeldungSymbolMitLaengeFigure figure;

    TmcMeldungSymbolMitLaengeEmpfaenger(TmcMeldungEditPart<?> editPart, TmcMeldungSymbolMitLaengeFigure figure) {
        super(editPart);
        this.figure = figure;
    }

    @Override
    public final void datensatzAktualisiert(final DatensatzUpdateEvent event) {
        if (!this.editPart.isActive()) {
            return;
        }
        this.updateZeitstempelLetzterDatensatz(event);
        if (PlatformUI.getWorkbench().getDisplay() != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TmcMeldungSymbolMitLaengeEmpfaenger.this.handleDatensatzAktualisiert((PdTmcVerkehrsMeldung.Daten)event.getDatum());
                    TmcMeldungSymbolMitLaengeEmpfaenger.this.editPart.refreshLocation();
                }
            });
        }
    }

    private void handleDatensatzAktualisiert(PdTmcVerkehrsMeldung.Daten datum) {
        if (datum.dContainsDaten()) {
            this.streckenabschnitt = this.getStreckenabschnitt(datum);
            RdsCode priosymb = RdsCode.DEFAULT;
            Long laenge = null;
            if (datum.getTMCDaten().getEreignisInformationen().getEreignisDaten().size() > 0) {
                int lauf = 0;
                while (lauf < datum.getTMCDaten().getEreignisInformationen().getEreignisDaten().size()) {
                    int code = ((AtlTmcEreignisDaten)datum.getTMCDaten().getEreignisInformationen().getEreignisDaten().get(lauf)).getEreignisCode().intValue();
                    RdsCode symb = code != 0 ? this.getTabelle().getZuordnung().get(code) : RdsCode.RDSMELDUNG;
                    if (symb.compareTo(priosymb) < 0 && (priosymb = symb) == RdsCode.STAU) {
                        if (laenge == null) {
                            laenge = this.parseCodeStr(((AtlTmcEreignisDaten)datum.getTMCDaten().getEreignisInformationen().getEreignisDaten().get(lauf)).getEreignisCode().toString());
                        }
                        if (laenge == null) {
                            laenge = this.parseCodeStr(datum.getBeschreibung().toString());
                        }
                    }
                    ++lauf;
                }
            }
            this.figure.setImage(this.getTabelle().getImageByRdsCode(priosymb), laenge);
        } else {
            this.streckenabschnitt = new PointList();
        }
    }

    private Long parseCodeStr(String string) {
        Long result = null;
        if (string != null) {
            String[] parts = string.split(" ");
            int idx = 0;
            while (idx < parts.length) {
                if (parts[idx].equalsIgnoreCase("km") && idx > 0) {
                    try {
                        result = Long.parseLong(parts[idx - 1]);
                    }
                    catch (NumberFormatException e) {
                        Debug.getLogger().finest("", (Throwable)e);
                    }
                    if (result == null) {
                        try {
                            String[] parts2 = parts[idx - 1].split("\n");
                            result = Long.parseLong(parts2[1]);
                        }
                        catch (NumberFormatException e) {
                            Debug.getLogger().finest("", (Throwable)e);
                        }
                    }
                }
                ++idx;
            }
        }
        return result;
    }
}

