/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.rahmen.editpart;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ContainerEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

import com.bitctrl.lib.eclipse.emf.gef.commands.AddCommand;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.rahmen.RahmenDoModel;
import de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm;

/**
 * Editpolicy für das Hinzufügen von Darstellungsobjekten zu einem Rahmen DO via
 * Drag'n Drop.
 *
 * @author BitCtrl Systems GmbH, Ch. Hösel
 *
 */
public class RahmenContainerEditPolicy extends ContainerEditPolicy {

	@Override
	protected Command getCreateCommand(final CreateRequest request) {
		Object newObject = request.getNewObject();

		if (newObject instanceof final ExternalDoForm doForm) {
			newObject = doForm.getDarstellungsObjektTyp().createModel();
		}

		if (newObject instanceof final DoModel doModel) {
			final IFigure figure = ((GraphicalEditPart) getHost()).getFigure();

			final Point location = request.getLocation().getCopy();
			figure.translateToRelative(location);
			figure.translateFromParent(location);
			doModel.setLocation(location);

			return new AddCommand((RahmenDoModel) getHost().getModel(), DobjPackage.Literals.DO_KOMPOSITUM__KOMPONENTEN,
					doModel);
		}
		return null;
	}


}
