/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.rahmen.editpart;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

import com.bitctrl.lib.eclipse.emf.gef.commands.AddCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.darstellung.editparts.EbeneEditPart;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.rahmen.RahmenDoModel;

/**
 * Editpolicy für das Rahmen DO.
 *
 * @author BitCtrl Systems GmbH, Ch. Hösel
 *
 */
public class RahmenContainerLayoutEditPolicy extends XYLayoutEditPolicy {

	@Override
	protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
		if(child.getModel() instanceof final DoModel modul && constraint instanceof final Rectangle bounds) {
			return new SetCommand(modul, GefPackage.Literals.LOCATED__LOCATION, bounds.getLocation());
		}
		return super.createChangeConstraintCommand(request, child, constraint);
	}

	@Override
	protected Command createAddCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
		final RahmenDoModel rahmen = (RahmenDoModel) getHost().getModel();
		if (child.getModel() instanceof final DoModel modul) {
			final Rectangle bounds = (Rectangle) constraint;
			final AddCommand addCommand = new AddCommand(rahmen, DobjPackage.Literals.DO_KOMPOSITUM__KOMPONENTEN,
					modul);
			final SetCommand setCommand = new SetCommand(modul, GefPackage.Literals.LOCATED__LOCATION,
					bounds.getLocation());

			final CompoundCommand cmd = new CompoundCommand();
			cmd.add(addCommand);
			cmd.add(setCommand);
			return cmd.unwrap();
		}
		return super.createAddCommand(request, child, constraint);
	}

	@Override
	protected Command getMoveChildrenCommand(Request request) {
		final ChangeBoundsRequest cbRequest = (ChangeBoundsRequest) request;
		for (final EditPart o : cbRequest.getEditParts()) {
			if (o instanceof final GraphicalEditPart gEditPart) {
				final IFigure figure = gEditPart.getFigure();
				final Point location = figure.getBounds().getLocation().getCopy();
				getHostFigure().translateToParent(location);

				final Point neuerPunkt = location.getTranslated(cbRequest.getMoveDelta());
				if (!getHostFigure().containsPoint(neuerPunkt) && gEditPart.getModel() instanceof final DoModel doModel) {
					final ChangeBoundsRequest moveRequest = new ChangeBoundsRequest(REQ_MOVE);
					moveRequest.setEditParts(cbRequest.getEditParts());
					moveRequest.setExtendedData(cbRequest.getExtendedData());
					moveRequest.setLocation(cbRequest.getLocation());
					moveRequest.setSizeDelta(cbRequest.getSizeDelta());

					final EditPart newTarget = getHost().getParent().getTargetEditPart(moveRequest);
					if (newTarget instanceof final EbeneEditPart ebeneEditPart) {
						final AddCommand addCommand = new AddCommand(ebeneEditPart.getModel(),
								DarstellungPackage.Literals.EBENE__DO_OBJEKTE, doModel);
						final SetCommand setCommand = new SetCommand(doModel, GefPackage.Literals.LOCATED__LOCATION,
								neuerPunkt);
						final CompoundCommand cmd = new CompoundCommand();
						cmd.add(addCommand);
						cmd.add(setCommand);
						return cmd.unwrap();
					}
					return getHost().getParent().getCommand(cbRequest);
				}
			}
		}
		return super.getMoveChildrenCommand(request);
	}

	@Override
	protected Command getCreateCommand(CreateRequest request) {
		return null;
	}

}
