/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.rahmen.editpart;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gef.rulers.RulerProvider;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.util.EmfUtil;

import de.bsvrz.buv.plugin.dobj.decorator.HintergrundfarbeMediator;
import de.bsvrz.buv.plugin.dobj.decorator.LinienstaerkeMediator;
import de.bsvrz.buv.plugin.dobj.decorator.SchriftMediator;
import de.bsvrz.buv.plugin.dobj.decorator.VordergrundfarbeMediator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.rahmen.RahmenDoModel;
import de.bsvrz.buv.plugin.dobj.rahmen.RahmenPackage;

/**
 * Editpart für das Rahmen DO.
 *
 * @author BitCtrl Systems GmbH, Ch. Hösel
 *
 */
public class RahmenEditPart extends DoModelEditPart<RahmenDoModel, RahmenFigure> {

	@Override
	protected List<DoModel> getModelChildren() {
		return super.getModel().getKomponenten();
	}

	@Override
	protected RahmenFigure createFigure() {
		return new RahmenFigure();
	}

	@Override
	public void notifyChanged(Notification notification) {
		super.notifyChanged(notification);
		if (GefPackage.Literals.SIZED__SIZE.equals(notification.getFeature())
				|| DobjDecoratorPackage.Literals.LINIENSTAERKE_DECORATOR__LINIENSTAERKE
						.equals(notification.getFeature())
				|| DobjDecoratorPackage.Literals.HINTERGRUNDFARBE_DECORATOR__HINTERGRUNDFARBE
						.equals(notification.getFeature())
				|| DobjDecoratorPackage.Literals.VORDERGRUNDFARBE_DECORATOR__VORDERGRUNDFARBE
						.equals(notification.getFeature())
				|| DobjDecoratorPackage.Literals.SCHRIFT_DECORATOR__SCHRIFT.equals(notification.getFeature())
				|| DobjDecoratorPackage.Literals.SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR
						.equals(notification.getFeature())
				|| EclipsePackage.Literals.NAMED__NAME.equals(notification.getFeature())) {
			refreshVisuals();
		} else {
			switch (notification.getEventType()) {
			case Notification.ADD,
			Notification.ADD_MANY,
			Notification.MOVE,
			Notification.REMOVE,
			Notification.REMOVE_MANY:
				switch (notification.getFeatureID(RahmenDoModel.class)) {
				case RahmenPackage.RAHMEN_DO_MODEL__KOMPONENTEN:
					refreshChildren();
					break;
				}
				break;
			}

		}
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		if (isEditor()) {
			installEditPolicy(EditPolicy.CONTAINER_ROLE, new RahmenContainerEditPolicy());
			installEditPolicy(EditPolicy.LAYOUT_ROLE, new RahmenContainerLayoutEditPolicy());
			installEditPolicy("Snap Feedback", new SnapFeedbackPolicy());
		}
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		new LinienstaerkeMediator(this).mediate();
		new HintergrundfarbeMediator(this).mediate();
		new VordergrundfarbeMediator(this).mediate();
		new SchriftMediator(this).mediate();
		getFigure().setText(EmfUtil.getText(getModel()));
		if (getModel().getSize() != null) {
			getFigure().setSize(getModel().getSize().getCopy());
		} else {
			getFigure().setSize(new Dimension(100, 100));
		}
	}

	/**
	 * Wenn der Edit Part in einem Editor dargestellt wird, dann gibt die Methode
	 * folgende Adapter zurück.
	 *
	 * <ul>
	 * <li>{@link SnapToHelper}</li>
	 * </ul>
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public Object getAdapter(final Class adapter) {
		if (adapter == SnapToHelper.class && isEditor()) {
			final List<SnapToHelper> snapStrategies = new ArrayList<>();
			Boolean val = (Boolean) getViewer().getProperty(RulerProvider.PROPERTY_RULER_VISIBILITY);
			if (val != null && val.booleanValue()) {
				snapStrategies.add(new SnapToGuides(this));
			}
			val = (Boolean) getViewer().getProperty(SnapToGeometry.PROPERTY_SNAP_ENABLED);
			if (val != null && val.booleanValue()) {
				snapStrategies.add(new SnapToGeometry(this));
			}
			val = (Boolean) getViewer().getProperty(SnapToGrid.PROPERTY_GRID_ENABLED);
			if (val != null && val.booleanValue()) {
				snapStrategies.add(new SnapToGrid(this));
			}

			if (snapStrategies.isEmpty()) {
				return null;
			}
			if (snapStrategies.size() == 1) {
				return snapStrategies.get(0);
			}

			final SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
			for (int i = 0; i < snapStrategies.size(); i++) {
				ss[i] = snapStrategies.get(i);
			}
			return new CompoundSnapToHelper(ss);
		}

		return super.getAdapter(adapter);
	}

}
