/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.rahmen.editpart;

import org.eclipse.draw2d.GroupBoxBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.dobj.decorator.LinienstaerkeFigure;

/**
 * Die Figure zur Darstellung des Rahmen DO.
 *
 * @author BitCtrl Systems GmbH, Ch. Hösel
 *
 */
public class RahmenFigure extends RectangleFigure implements LinienstaerkeFigure {

	private String text = "Hello World";
	private final GroupBoxBorder boxBorder = new GroupBoxBorder(text);
	private int maximaleLinienstaerke;
	private int minimaleLinienstarke;
	private double maximaleZoomstufe;
	private double minimaleZoomstufe;
	private int linienstaerke;

	public RahmenFigure() {
		super();
		setLayoutManager(new XYLayout());
		setBorder(boxBorder);
	}

	@Override
	public void setFont(Font f) {
		super.setFont(f);
		boxBorder.setFont(f);

	}

	@Override
	public int getLinienstaerke() {
		return linienstaerke;
	}

	@Override
	public void setLinienstaerke(int linienstaerke) {
		if (this.linienstaerke == linienstaerke) {
			return;
		}

		this.linienstaerke = linienstaerke;
	}

	/**
	 * @return the text
	 */
	public final String getText() {
		return text;
	}

	@Override
	public void setBackgroundColor(Color bg) {
		super.setBackgroundColor(bg);
		final ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
		final RGB white = new RGB(255, 255, 255);
		final RGB black = new RGB(0, 0, 0);
		Color textColor = colorRegistry.get(black.toString());
		if (textColor == null) {
			colorRegistry.put(black.toString(), black);
			textColor = colorRegistry.get(black.toString());
		}

		if (brightness(bg) < 130) {
			textColor = colorRegistry.get(white.toString());
			if (textColor == null) {
				colorRegistry.put(white.toString(), white);
				textColor = colorRegistry.get(white.toString());
			}
		}
		boxBorder.setTextColor(textColor);
	}

	/**
	 * Errechnet die Helligekeit der Farbe. Color textColor =
	 * Brightness(backgroundColor) < 130 ? Colors.White : Colors.Black;
	 *
	 * @param c
	 * @return
	 */
	private static int brightness(Color c) {
		return (int) Math.sqrt(
				c.getRed() * c.getRed() * .241 + c.getGreen() * c.getGreen() * .691 + c.getBlue() * c.getBlue() * .068);

	}

	/**
	 * @param text the text to set
	 */
	public final void setText(String text) {
		this.text = text;
		boxBorder.setLabel(" "+text + "\t");
		repaint();
	}

	@Override
	protected boolean useLocalCoordinates() {
		return true;
	}

	@Override
	public void setLinienstaerkeMaximum(final int maximaleLinienstaerke) {
		this.maximaleLinienstaerke = maximaleLinienstaerke;
		repaint();
	}

	@Override
	public int getLinienstaerkeMaximum() {
		return maximaleLinienstaerke;
	}

	@Override
	public void setLinienstaerkeMinimum(final int minimaleLinienstarke) {
		this.minimaleLinienstarke = minimaleLinienstarke;
		repaint();
	}

	@Override
	public int getLinienstaerkeMinimum() {
		return minimaleLinienstarke;
	}

	@Override
	public void setLinienstaerkeMaximaleZoomstufe(final double maximaleZoomstufe) {
		this.maximaleZoomstufe = maximaleZoomstufe;
		repaint();
	}

	@Override
	public double getLinienstaerkeMaximaleZoomstufe() {
		return maximaleZoomstufe;
	}

	@Override
	public void setLinienstaerkeMinimaleZoomstufe(final double minimaleZoomstufe) {
		this.minimaleZoomstufe = minimaleZoomstufe;
		repaint();
	}

	@Override
	public double getLinienstaerkeMinimaleZoomstufe() {
		return minimaleZoomstufe;
	}
}
