/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.rahmen.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipseFactory;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.model.impl.ConfiguratedDoTypImpl;
import de.bsvrz.buv.plugin.dobj.rahmen.RahmenDoTyp;
import de.bsvrz.buv.plugin.dobj.rahmen.RahmenPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Do
 * Typ</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.dobj.rahmen.impl.RahmenDoTypImpl#getLinienstaerke
 * <em>Linienstaerke</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.rahmen.impl.RahmenDoTypImpl#getVordergrundfarbe
 * <em>Vordergrundfarbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.rahmen.impl.RahmenDoTypImpl#getHintergrundfarbe
 * <em>Hintergrundfarbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.dobj.rahmen.impl.RahmenDoTypImpl#getSchrift
 * <em>Schrift</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RahmenDoTypImpl extends ConfiguratedDoTypImpl implements RahmenDoTyp {
	/**
	 * The default value of the '{@link #getLinienstaerke() <em>Linienstaerke</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerke()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_EDEFAULT = 1;
	/**
	 * The cached value of the '{@link #getLinienstaerke() <em>Linienstaerke</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerke()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerke = LINIENSTAERKE_EDEFAULT;
	/**
	 * This is true if the Linienstaerke attribute has been set. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeESet;
	/**
	 * The default value of the '{@link #getVordergrundfarbe()
	 * <em>Vordergrundfarbe</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getVordergrundfarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB VORDERGRUNDFARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "0,0,0");
	/**
	 * The cached value of the '{@link #getVordergrundfarbe()
	 * <em>Vordergrundfarbe</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getVordergrundfarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB vordergrundfarbe = VORDERGRUNDFARBE_EDEFAULT;
	/**
	 * This is true if the Vordergrundfarbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean vordergrundfarbeESet;
	/**
	 * The default value of the '{@link #getHintergrundfarbe()
	 * <em>Hintergrundfarbe</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getHintergrundfarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB HINTERGRUNDFARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "255,255,255");
	/**
	 * The cached value of the '{@link #getHintergrundfarbe()
	 * <em>Hintergrundfarbe</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getHintergrundfarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB hintergrundfarbe = HINTERGRUNDFARBE_EDEFAULT;
	/**
	 * This is true if the Hintergrundfarbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean hintergrundfarbeESet;
	/**
	 * The default value of the '{@link #getSchrift() <em>Schrift</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getSchrift()
	 * @generated
	 * @ordered
	 */
	protected static final FontData SCHRIFT_EDEFAULT = null;
	/**
	 * The cached value of the '{@link #getSchrift() <em>Schrift</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getSchrift()
	 * @generated
	 * @ordered
	 */
	protected FontData schrift = SCHRIFT_EDEFAULT;
	/**
	 * This is true if the Schrift attribute has been set. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean schriftESet;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RahmenDoTypImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RahmenPackage.Literals.RAHMEN_DO_TYP;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerke() {
		return linienstaerke;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerke(int newLinienstaerke) {
		final int oldLinienstaerke = linienstaerke;
		linienstaerke = newLinienstaerke;
		final boolean oldLinienstaerkeESet = linienstaerkeESet;
		linienstaerkeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, RahmenPackage.RAHMEN_DO_TYP__LINIENSTAERKE,
					oldLinienstaerke, linienstaerke, !oldLinienstaerkeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerke() {
		final int oldLinienstaerke = linienstaerke;
		final boolean oldLinienstaerkeESet = linienstaerkeESet;
		linienstaerke = LINIENSTAERKE_EDEFAULT;
		linienstaerkeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET, RahmenPackage.RAHMEN_DO_TYP__LINIENSTAERKE,
					oldLinienstaerke, LINIENSTAERKE_EDEFAULT, oldLinienstaerkeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerke() {
		return linienstaerkeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getVordergrundfarbe() {
		return vordergrundfarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setVordergrundfarbe(RGB newVordergrundfarbe) {
		final RGB oldVordergrundfarbe = vordergrundfarbe;
		vordergrundfarbe = newVordergrundfarbe;
		final boolean oldVordergrundfarbeESet = vordergrundfarbeESet;
		vordergrundfarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, RahmenPackage.RAHMEN_DO_TYP__VORDERGRUNDFARBE,
					oldVordergrundfarbe, vordergrundfarbe, !oldVordergrundfarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetVordergrundfarbe() {
		final RGB oldVordergrundfarbe = vordergrundfarbe;
		final boolean oldVordergrundfarbeESet = vordergrundfarbeESet;
		vordergrundfarbe = VORDERGRUNDFARBE_EDEFAULT;
		vordergrundfarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET, RahmenPackage.RAHMEN_DO_TYP__VORDERGRUNDFARBE,
					oldVordergrundfarbe, VORDERGRUNDFARBE_EDEFAULT, oldVordergrundfarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetVordergrundfarbe() {
		return vordergrundfarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getHintergrundfarbe() {
		return hintergrundfarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setHintergrundfarbe(RGB newHintergrundfarbe) {
		final RGB oldHintergrundfarbe = hintergrundfarbe;
		hintergrundfarbe = newHintergrundfarbe;
		final boolean oldHintergrundfarbeESet = hintergrundfarbeESet;
		hintergrundfarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, RahmenPackage.RAHMEN_DO_TYP__HINTERGRUNDFARBE,
					oldHintergrundfarbe, hintergrundfarbe, !oldHintergrundfarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetHintergrundfarbe() {
		final RGB oldHintergrundfarbe = hintergrundfarbe;
		final boolean oldHintergrundfarbeESet = hintergrundfarbeESet;
		hintergrundfarbe = HINTERGRUNDFARBE_EDEFAULT;
		hintergrundfarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET, RahmenPackage.RAHMEN_DO_TYP__HINTERGRUNDFARBE,
					oldHintergrundfarbe, HINTERGRUNDFARBE_EDEFAULT, oldHintergrundfarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetHintergrundfarbe() {
		return hintergrundfarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public FontData getSchrift() {
		return schrift;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setSchrift(FontData newSchrift) {
		final FontData oldSchrift = schrift;
		schrift = newSchrift;
		final boolean oldSchriftESet = schriftESet;
		schriftESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, RahmenPackage.RAHMEN_DO_TYP__SCHRIFT, oldSchrift,
					schrift, !oldSchriftESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetSchrift() {
		final FontData oldSchrift = schrift;
		final boolean oldSchriftESet = schriftESet;
		schrift = SCHRIFT_EDEFAULT;
		schriftESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET, RahmenPackage.RAHMEN_DO_TYP__SCHRIFT, oldSchrift,
					SCHRIFT_EDEFAULT, oldSchriftESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetSchrift() {
		return schriftESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case RahmenPackage.RAHMEN_DO_TYP__LINIENSTAERKE:
			return getLinienstaerke();
		case RahmenPackage.RAHMEN_DO_TYP__VORDERGRUNDFARBE:
			return getVordergrundfarbe();
		case RahmenPackage.RAHMEN_DO_TYP__HINTERGRUNDFARBE:
			return getHintergrundfarbe();
		case RahmenPackage.RAHMEN_DO_TYP__SCHRIFT:
			return getSchrift();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case RahmenPackage.RAHMEN_DO_TYP__LINIENSTAERKE:
			setLinienstaerke((Integer) newValue);
			return;
		case RahmenPackage.RAHMEN_DO_TYP__VORDERGRUNDFARBE:
			setVordergrundfarbe((RGB) newValue);
			return;
		case RahmenPackage.RAHMEN_DO_TYP__HINTERGRUNDFARBE:
			setHintergrundfarbe((RGB) newValue);
			return;
		case RahmenPackage.RAHMEN_DO_TYP__SCHRIFT:
			setSchrift((FontData) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case RahmenPackage.RAHMEN_DO_TYP__LINIENSTAERKE:
			unsetLinienstaerke();
			return;
		case RahmenPackage.RAHMEN_DO_TYP__VORDERGRUNDFARBE:
			unsetVordergrundfarbe();
			return;
		case RahmenPackage.RAHMEN_DO_TYP__HINTERGRUNDFARBE:
			unsetHintergrundfarbe();
			return;
		case RahmenPackage.RAHMEN_DO_TYP__SCHRIFT:
			unsetSchrift();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case RahmenPackage.RAHMEN_DO_TYP__LINIENSTAERKE:
			return isSetLinienstaerke();
		case RahmenPackage.RAHMEN_DO_TYP__VORDERGRUNDFARBE:
			return isSetVordergrundfarbe();
		case RahmenPackage.RAHMEN_DO_TYP__HINTERGRUNDFARBE:
			return isSetHintergrundfarbe();
		case RahmenPackage.RAHMEN_DO_TYP__SCHRIFT:
			return isSetSchrift();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == LinienstaerkeDecorator.class) {
			switch (derivedFeatureID) {
			case RahmenPackage.RAHMEN_DO_TYP__LINIENSTAERKE:
				return DobjDecoratorPackage.LINIENSTAERKE_DECORATOR__LINIENSTAERKE;
			default:
				return -1;
			}
		}
		if (baseClass == VordergrundfarbeDecorator.class) {
			switch (derivedFeatureID) {
			case RahmenPackage.RAHMEN_DO_TYP__VORDERGRUNDFARBE:
				return DobjDecoratorPackage.VORDERGRUNDFARBE_DECORATOR__VORDERGRUNDFARBE;
			default:
				return -1;
			}
		}
		if (baseClass == HintergrundfarbeDecorator.class) {
			switch (derivedFeatureID) {
			case RahmenPackage.RAHMEN_DO_TYP__HINTERGRUNDFARBE:
				return DobjDecoratorPackage.HINTERGRUNDFARBE_DECORATOR__HINTERGRUNDFARBE;
			default:
				return -1;
			}
		}
		if (baseClass == SchriftDecorator.class) {
			switch (derivedFeatureID) {
			case RahmenPackage.RAHMEN_DO_TYP__SCHRIFT:
				return DobjDecoratorPackage.SCHRIFT_DECORATOR__SCHRIFT;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == LinienstaerkeDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.LINIENSTAERKE_DECORATOR__LINIENSTAERKE:
				return RahmenPackage.RAHMEN_DO_TYP__LINIENSTAERKE;
			default:
				return -1;
			}
		}
		if (baseClass == VordergrundfarbeDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.VORDERGRUNDFARBE_DECORATOR__VORDERGRUNDFARBE:
				return RahmenPackage.RAHMEN_DO_TYP__VORDERGRUNDFARBE;
			default:
				return -1;
			}
		}
		if (baseClass == HintergrundfarbeDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.HINTERGRUNDFARBE_DECORATOR__HINTERGRUNDFARBE:
				return RahmenPackage.RAHMEN_DO_TYP__HINTERGRUNDFARBE;
			default:
				return -1;
			}
		}
		if (baseClass == SchriftDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.SCHRIFT_DECORATOR__SCHRIFT:
				return RahmenPackage.RAHMEN_DO_TYP__SCHRIFT;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (linienstaerke: ");
		if (linienstaerkeESet) {
			result.append(linienstaerke);
		} else {
			result.append("<unset>");
		}
		result.append(", vordergrundfarbe: ");
		if (vordergrundfarbeESet) {
			result.append(vordergrundfarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", hintergrundfarbe: ");
		if (hintergrundfarbeESet) {
			result.append(hintergrundfarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", schrift: ");
		if (schriftESet) {
			result.append(schrift);
		} else {
			result.append("<unset>");
		}
		result.append(')');
		return result.toString();
	}

} // RahmenDoTypImpl
