/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.rahmen.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import com.bitctrl.lib.eclipse.emf.dav.model.DavPackage;
import com.bitctrl.lib.eclipse.emf.davbitctrl.model.DavbitctrlPackage;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.rahmen.RahmenDoModel;
import de.bsvrz.buv.plugin.dobj.rahmen.RahmenDoTyp;
import de.bsvrz.buv.plugin.dobj.rahmen.RahmenFactory;
import de.bsvrz.buv.plugin.dobj.rahmen.RahmenPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class RahmenPackageImpl extends EPackageImpl implements RahmenPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass rahmenDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass rahmenDoModelEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory method
	 * {@link #init init()}, which also performs initialization of the package, or
	 * returns the registered package, if one already exists. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.bsvrz.buv.plugin.dobj.rahmen.RahmenPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private RahmenPackageImpl() {
		super(eNS_URI, RahmenFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and
	 * for any others upon which it depends.
	 *
	 * <p>
	 * This method is used to initialize {@link RahmenPackage#eINSTANCE} when that
	 * field is accessed. Clients should not invoke it directly. Instead, they
	 * should simply access that field to obtain the package. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static RahmenPackage init() {
		if (isInited) {
			return (RahmenPackage) EPackage.Registry.INSTANCE.getEPackage(RahmenPackage.eNS_URI);
		}

		// Obtain or create and register package
		final Object registeredRahmenPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		final RahmenPackageImpl theRahmenPackage = registeredRahmenPackage instanceof RahmenPackageImpl
				? (RahmenPackageImpl) registeredRahmenPackage
				: new RahmenPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		DavPackage.eINSTANCE.eClass();
		DavbitctrlPackage.eINSTANCE.eClass();
		DobjPackage.eINSTANCE.eClass();
		DobjDecoratorPackage.eINSTANCE.eClass();
		EclipsePackage.eINSTANCE.eClass();
		GefPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theRahmenPackage.createPackageContents();

		// Initialize created meta-data
		theRahmenPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theRahmenPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(RahmenPackage.eNS_URI, theRahmenPackage);
		return theRahmenPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getRahmenDoTyp() {
		return rahmenDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getRahmenDoModel() {
		return rahmenDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RahmenFactory getRahmenFactory() {
		return (RahmenFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package. This method is guarded to
	 * have no affect on any invocation but its first. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) {
			return;
		}
		isCreated = true;

		// Create classes and their features
		rahmenDoTypEClass = createEClass(RAHMEN_DO_TYP);

		rahmenDoModelEClass = createEClass(RAHMEN_DO_MODEL);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This method is
	 * guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) {
			return;
		}
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		final DobjPackage theDobjPackage = (DobjPackage) EPackage.Registry.INSTANCE.getEPackage(DobjPackage.eNS_URI);
		final DobjDecoratorPackage theDobjDecoratorPackage = (DobjDecoratorPackage) EPackage.Registry.INSTANCE
				.getEPackage(DobjDecoratorPackage.eNS_URI);
		final GefPackage theGefPackage = (GefPackage) EPackage.Registry.INSTANCE.getEPackage(GefPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		rahmenDoTypEClass.getESuperTypes().add(theDobjPackage.getConfiguratedDoTyp());
		rahmenDoTypEClass.getESuperTypes().add(theDobjDecoratorPackage.getLinienstaerkeDecorator());
		rahmenDoTypEClass.getESuperTypes().add(theDobjDecoratorPackage.getVordergrundfarbeDecorator());
		rahmenDoTypEClass.getESuperTypes().add(theDobjDecoratorPackage.getHintergrundfarbeDecorator());
		rahmenDoTypEClass.getESuperTypes().add(theDobjDecoratorPackage.getSchriftDecorator());
		EGenericType g1 = createEGenericType(theDobjPackage.getDoModel());
		rahmenDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theDobjPackage.getDoKompositum());
		final EGenericType g2 = createEGenericType(theDobjPackage.getDoModel());
		g1.getETypeArguments().add(g2);
		rahmenDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theDobjDecoratorPackage.getLinienstaerkeDecorator());
		rahmenDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theDobjDecoratorPackage.getSchriftDecorator());
		rahmenDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theDobjDecoratorPackage.getHintergrundfarbeDecorator());
		rahmenDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theDobjDecoratorPackage.getVordergrundfarbeDecorator());
		rahmenDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theGefPackage.getSized());
		rahmenDoModelEClass.getEGenericSuperTypes().add(g1);

		// Initialize classes and features; add operations and parameters
		initEClass(rahmenDoTypEClass, RahmenDoTyp.class, "RahmenDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(rahmenDoModelEClass, RahmenDoModel.class, "RahmenDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);
	}

} // RahmenPackageImpl
