/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import de.bsvrz.buv.plugin.darstellung.editors.AnsichtEditor;

/**
 * Enthält Konstanten der Aktionen im Plug-in <em>Darstellungsobjekte</em> für
 * den Teil <em>Darstellung</em>.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public interface DarstellungActionConstants {

	/** Konstante für den Property Contributor des {@link AnsichtEditor}. */
	String ANSICHT_PROPERTIES = "de.bsvrz.buv.plugin.darstellung.ansicht.propertyContributor";

	/** Konstante für das entsprechende Kommando. */
	String ZEIGE_ANSICHT = "de.bsvrz.buv.plugin.darstellung.command.zeigeAnsicht";

	/** Konstante für das entsprechende Kommando. */
	String EDIT_ANSICHTEN = "de.bsvrz.buv.plugin.darstellung.command.editAnichten";

}
