/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import de.bsvrz.buv.plugin.darstellung.dialogs.AnsichtenDialog;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;

/**
 * Öffnet den Dialog mit den globalen Einstellungen für Ansichten.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class EditAnsichtenAction extends Action {

	private final Shell parentShell;

	/**
	 * Initialisiert die Aktion.
	 *
	 * @param parentShell
	 *            die Parent Shell für Dialoge der Aktion. Darf
	 *            <code>null</code> sein.
	 */
	public EditAnsichtenAction(final Shell parentShell) {
		super("Ansichten bearbeiten",
				DObjPlugin.getDefault().getImageDescriptor("icons/16x16/actions/ansichten-edit.png"));
		setId(DarstellungActionConstants.EDIT_ANSICHTEN);
		setActionDefinitionId(DarstellungActionConstants.EDIT_ANSICHTEN);

		this.parentShell = parentShell;
	}

	@Override
	public void run() {
		final ObjektFactory nutzerverbindung = RahmenwerkService.getService().getObjektFactory();
		if (nutzerverbindung.isVerbunden()) {
			final AnsichtenDialog dlg = new AnsichtenDialog(parentShell);
			dlg.open();
		} else {
			MessageDialog.openInformation(parentShell, "Aktion nicht möglich",
					"Es besteht keine Verbindung zum Datenverteiler.");
		}
	}

}
