/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;

/**
 * Schaltet die markierte Ebene in den Bearbeitungsmodus.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class EditEbeneAction extends Action implements ISelectionChangedListener {

	private final EditPartViewer viewer;

	/**
	 * Initialisiert die Action.
	 *
	 * @param viewer
	 *            der Viewer mit dem die Action zusammenarbeiten soll.
	 */
	public EditEbeneAction(final EditPartViewer viewer) {
		setText("Ebene bearbeiten");
		setImageDescriptor(DarstellungIcons.ActionEditEbene.getImageDescriptor());

		setToolTipText(
				"Versetzt die ausgewählte Ebene in den Bearbeitungsmodus und alle anderen in den normalen Modus.");

		this.viewer = viewer;
		viewer.addSelectionChangedListener(this);
	}

	@Override
	public void run() {
		final Ebene current = getSelection();
		final EObject root = EcoreUtil.getRootContainer(current);
		final TreeIterator<Object> allContents = EcoreUtil.getAllContents(root, true);

		allContents.forEachRemaining(obj -> {
			if (obj instanceof final Ebene ebene) {
				if (current.equals(ebene)) {
					ebene.setEditable(true);
				} else {
					ebene.setEditable(false);
				}
			}
		});

	}

	private Ebene getSelection() {
		final List<?> editParts = viewer.getSelectedEditParts();
		if (!editParts.isEmpty() && ((EditPart) editParts.get(0)).getModel() instanceof Ebene) {
			return (Ebene) ((EditPart) editParts.get(0)).getModel();
		}

		return null;
	}

	@Override
	public void selectionChanged(final SelectionChangedEvent event) {
		setEnabled(getSelection() != null);
	}

}
