/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

import de.bsvrz.buv.plugin.darstellung.dialogs.OverviewWindow;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;

/**
 * Diese Aktion öffnet und schließt die Übersicht für einen Workbench Part.
 *
 * <p>
 * Der Workbench Part muss einen Adapter für {@link GraphicalViewer}
 * bereitstellen.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class ToggleOverviewAction extends Action {

	private final IWorkbenchPart part;
	private OverviewWindow window;
	private final Control control;

	/**
	 * Initialisiert die Aktion.
	 *
	 * @param part
	 *            der Workbench Part für den die Übersicht gilt.
	 */
	public ToggleOverviewAction(final IWorkbenchPart part, final Control control) {
		super("Übersicht ein-/ausblenden", AS_CHECK_BOX);
		this.part = part;
		this.control = control;

		setImageDescriptor(DarstellungIcons.ActionToggleOverview.getImageDescriptor());
		setToolTipText("Blendet die Übersicht ein und aus.");

		setId(DarstellungActionFactory.TOGGLE_OVERVIEW.getCommandId());
		setActionDefinitionId(DarstellungActionFactory.TOGGLE_OVERVIEW.getCommandId());
	}

	@Override
	public void run() {
		if (window != null) {
			window.close();
			window = null;
		} else {
			window = new OverviewWindow(part, control);
			window.open();
			window.getShell().addDisposeListener(e -> {
				setChecked(false);
				window = null;
			});
		}
	}

}
