/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;

import de.bsvrz.buv.plugin.darstellung.editors.AnsichtEditor;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.editors.EmfEinstellungenEditorInput;

/**
 * Aktion zum Öffnen einer Ansicht.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class ZeigeAnsichtAction extends Action {

	private final IWorkbenchPart part;

	/**
	 * Initialisiert die Aktion.
	 *
	 * @param part
	 *            der Workbench Part an dem die Aktion gebunden ist.
	 */
	public ZeigeAnsichtAction(final IWorkbenchPart part) {
		super("Ansicht öffnen");
		setId(DarstellungActionConstants.ZEIGE_ANSICHT);
		setActionDefinitionId(DarstellungActionConstants.ZEIGE_ANSICHT);

		this.part = part;
	}

	@Override
	public void run() {
		final ITreeSelection selection = (ITreeSelection) part.getSite().getSelectionProvider().getSelection();
		for (final TreePath path : selection.getPaths()) {
			final SpeicherKey einstellungsArt = (SpeicherKey) path.getFirstSegment();
			if (path.getLastSegment() instanceof Ansicht) {
				final Ansicht ansicht = (Ansicht) path.getLastSegment();

				final IStatus status = EmfUtil.validate(ansicht, DObjPlugin.PLUGIN_ID);
				if (status.isOK()) {
					final EmfEinstellungenEditorInput input = new EmfEinstellungenEditorInput(ansicht, einstellungsArt);
					input.setExists(true);

					try {
						PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input,
								AnsichtEditor.EDITOR_ID);
					} catch (final PartInitException ex) {
						DObjPlugin.getDefault().getLog()
								.error("Die Ansicht \"" + ansicht + "\" konnte nicht geöffnet werden.", ex);
					}

				}

				ErrorDialog.openError(part.getSite().getShell(), "Ansicht nicht darstellbar", "Die Ansicht \""
						+ ansicht.getName() + "\" kann nicht geöffnet werden, weil sie nicht lesbar ist.", status);
			}
		}
	}

}
