/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;

/**
 * Verschiebt ein Ebene von einer Ebene auf eine andere.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class AddEbeneToEbeneCommand extends Command {

	private final Ebene destination;
	private final Ebene model;
	private EObject oldContainer;
	private int indexInOldEbene;

	public AddEbeneToEbeneCommand(final Ebene model, final Ebene destination) {
		Assert.isNotNull(model, "model");
		Assert.isLegal(model.eContainer() instanceof Ebene || model.eContainer() instanceof Darstellung,
				"model muss in einer Ebene oder Darstellung liegen");
		Assert.isNotNull(destination, "ebene");

		this.model = model;
		this.destination = destination;

		setLabel("Ebene auf andere Ebene verschieben");
	}

	@Override
	public void execute() {
		oldContainer = model.eContainer();
		if (oldContainer instanceof Ebene) {
			indexInOldEbene = ((Ebene) oldContainer).getEbenen().indexOf(model);
		} else if (oldContainer instanceof Darstellung) {
			indexInOldEbene = ((Darstellung) oldContainer).getEbenen().indexOf(model);
		}

		redo();
	}

	@Override
	public void redo() {
		destination.getEbenen().add(model);
	}

	@Override
	public void undo() {
		if (oldContainer instanceof Ebene) {
			((Ebene) oldContainer).getEbenen().add(indexInOldEbene, model);
		} else if (oldContainer instanceof Darstellung) {
			((Darstellung) oldContainer).getEbenen().add(indexInOldEbene, model);
		}
	}

}
