/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.commands.Command;

import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

public class ChangeIndexOfDoModelCommand extends Command {

	private final Ebene ebene;
	private final int newIndexInEbene;
	private final int oldIndexInEbene;

	public ChangeIndexOfDoModelCommand(final DoModel model, final Ebene ebene, final int newIndex) {
		Assert.isNotNull(model, "model");
		Assert.isNotNull(ebene, "ebene");

		this.ebene = ebene;
		oldIndexInEbene = ebene.getDoObjekte().indexOf(model);
		if (newIndex > oldIndexInEbene) {
			newIndexInEbene = newIndex - 1;
		} else {
			newIndexInEbene = newIndex;
		}
	}

	@Override
	public boolean canExecute() {
		return oldIndexInEbene != newIndexInEbene && newIndexInEbene >= 0
				&& newIndexInEbene < ebene.getDoObjekte().size();
	}

	@Override
	public void execute() {
		Assert.isTrue(canExecute(), "command is not executable");

		redo();
	}

	@Override
	public void redo() {
		ebene.getDoObjekte().move(newIndexInEbene, oldIndexInEbene);
	}

	@Override
	public void undo() {
		ebene.getDoObjekte().move(oldIndexInEbene, newIndexInEbene);
	}

}
