/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.commands.Command;

import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungAdapter;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * Schaltet die automatische Verwaltung eines Darstellungsobjektes über die
 * Autoebene ein.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 *
 */
public class EnableAutoVerwaltungCommand extends Command {

	private final DoModel model;
	private final AutoEbene ebene;
	private Darstellung darstellung;

	public EnableAutoVerwaltungCommand(final DoModel model, final AutoEbene ebene) {
		Assert.isNotNull(model, "model");
		Assert.isNotNull(ebene, "ebene");

		this.model = model;
		this.ebene = ebene;
		setLabel("Automatische Verwaltung einschalten");
	}

	@Override
	public void execute() {
		Assert.isTrue(canExecute(), "command is not executable");

		darstellung = DarstellungAdapter.getDarstellung(ebene);
		Assert.isNotNull(darstellung, "darstellung");
		Assert.isLegal(darstellung instanceof MassstaeblicheDarstellung,
				"Darstellung muss eine maßstäblich Darstellung sein");

		redo();
	}

	@Override
	public boolean canExecute() {
		return !ebene.isAutomatischVerwaltet(model);
	}

	@Override
	public void undo() {
		ebene.getDoObjekte().add(model);
		ebene.getSystemObjectsExcludes().add(model.getSystemObject());
	}

	@Override
	public void redo() {
		ebene.getDoObjekte().remove(model);
		ebene.getSystemObjectsExcludes().remove(model.getSystemObject());

	}

}
